/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.list.paginated;

import io.github.palexdev.mfxcore.builders.bindings.DoubleBindingBuilder;
import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.list.VFXList;
import io.github.palexdev.virtualizedfx.list.VFXListSkin;
import io.github.palexdev.virtualizedfx.list.paginated.VFXPaginatedList;
import io.github.palexdev.virtualizedfx.list.paginated.VFXPaginatedListManager;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;

public class VFXPaginatedListSkin<T, C extends Cell<T>>
extends VFXListSkin<T, C> {
    protected DoubleBinding posBinding;

    public VFXPaginatedListSkin(VFXPaginatedList<T, C> list) {
        super(list);
        this.posBinding = (DoubleBinding)DoubleBindingBuilder.build().setMapper(() -> (double)(list.getPage() * list.getCellsPerPage()) * (list.getCellSize() + list.getSpacing())).addSources(new Observable[]{list.pageProperty(), list.cellsPerPageProperty(), list.cellSizeProperty(), list.spacingProperty()}).get();
        this.swapPositionBinding();
    }

    protected void swapPositionBinding() {
        if (this.posBinding == null) {
            return;
        }
        VFXList list = (VFXList)this.getSkinnable();
        Orientation o = list.getOrientation();
        if (o == Orientation.VERTICAL) {
            list.hPosProperty().unbind();
            list.vPosProperty().bind((ObservableValue)this.posBinding);
        } else {
            list.vPosProperty().unbind();
            list.hPosProperty().bind((ObservableValue)this.posBinding);
        }
    }

    protected final double getLength() {
        VFXPaginatedList<T, C> list = this.getList();
        return (double)list.getCellsPerPage() * (list.getCellSize() + list.getSpacing()) - list.getSpacing();
    }

    protected VFXPaginatedList<T, C> getList() {
        return (VFXPaginatedList)this.getSkinnable();
    }

    @Override
    protected void addListeners() {
        VFXPaginatedList<T, C> list = this.getList();
        super.addListeners();
        this.listeners(new When[]{When.onInvalidated((ObservableValue)list.cellsPerPageProperty()).then(cpp -> this.getBehavior().onCellsPerPageChanged()), When.onInvalidated((ObservableValue)list.maxPageProperty()).then(mp -> this.getBehavior().onMaxPageChanged())});
    }

    @Override
    protected void swapPositionListener() {
        super.swapPositionListener();
        this.swapPositionBinding();
    }

    protected VFXPaginatedListManager<T, C> getBehavior() {
        return (VFXPaginatedListManager)super.getBehavior();
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VFXList)this.getSkinnable()).getOrientation();
        if (o == Orientation.HORIZONTAL) {
            return this.getLength();
        }
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VFXList)this.getSkinnable()).getOrientation();
        if (o == Orientation.VERTICAL) {
            return this.getLength();
        }
        return super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VFXList)this.getSkinnable()).getOrientation();
        if (o == Orientation.HORIZONTAL) {
            return this.getLength();
        }
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VFXList)this.getSkinnable()).getOrientation();
        if (o == Orientation.VERTICAL) {
            return this.getLength();
        }
        return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VFXList)this.getSkinnable()).getOrientation();
        if (o == Orientation.HORIZONTAL) {
            return this.getLength();
        }
        return super.computeMaxWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Orientation o = ((VFXList)this.getSkinnable()).getOrientation();
        if (o == Orientation.VERTICAL) {
            return this.getLength();
        }
        return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

