/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import io.github.palexdev.virtualizedfx.cells.Cell;
import java.util.Collection;
import java.util.LinkedList;

public class CellsQueue<T, C extends Cell<T>>
extends LinkedList<C> {
    private int capacity;

    public CellsQueue(int capacity) {
        this.capacity = capacity;
    }

    public boolean queue(C c) {
        if (this.capacity == 0) {
            c.dispose();
            return false;
        }
        if (super.size() == this.capacity) {
            Cell excess = (Cell)super.remove();
            excess.dispose();
        }
        return super.add(c);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        if (capacity == 0) {
            this.forEach(Cell::dispose);
            this.clear();
            this.capacity = capacity;
            return;
        }
        if (capacity < super.size()) {
            for (int i = 0; i < super.size() - capacity; ++i) {
                Cell excess = (Cell)super.remove();
                excess.dispose();
            }
        }
        this.capacity = capacity;
    }

    @Override
    public boolean add(C c) {
        return this.queue(c);
    }

    @Override
    public boolean addAll(Collection<? extends C> cells) {
        boolean result = false;
        for (Cell c : cells) {
            result |= this.add((C)c);
        }
        return result;
    }
}

