/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import io.github.palexdev.virtualizedfx.cells.Cell;
import java.util.HashMap;
import java.util.Map;
import java.util.SequencedMap;
import java.util.TreeMap;

public class StateMap<T, C extends Cell<T>> {
    private final SequencedMap<Integer, C> byIndex = new TreeMap<Integer, C>();
    private final Map<T, Integer> byItem = new HashMap<T, Integer>();

    public C getCell(Integer index) {
        return (C)((Cell)this.byIndex.get(index));
    }

    public C getCell(T item) {
        Integer index = this.byItem.get(item);
        C c = this.getCell((T)index);
        if (c == null) {
            this.byItem.remove(item);
        }
        return c;
    }

    public void put(Integer index, T item, C cell) {
        if (index == null || item == null || cell == null) {
            throw new NullPointerException("Cannot add entry [Index:%s; Item:%s; Cell:%s] in state map".formatted(index, item, cell));
        }
        this.byIndex.put(index, cell);
        this.byItem.put(item, index);
    }

    public boolean contains(Integer index) {
        return this.byIndex.containsKey(index);
    }

    public boolean contains(T item) {
        return this.byItem.containsKey(item);
    }

    public C remove(Integer index) {
        return (C)((Cell)this.byIndex.remove(index));
    }

    public C remove(T item) {
        Integer index = this.byItem.remove(item);
        return (C)(index == null ? null : (Cell)this.byIndex.remove(index));
    }

    public Map.Entry<Integer, C> poll() {
        return this.byIndex.pollFirstEntry();
    }

    public int size() {
        return this.byIndex.size();
    }

    public boolean isEmpty() {
        return this.byIndex.isEmpty();
    }

    public void clear() {
        this.byIndex.clear();
        this.byItem.clear();
    }

    public Map<T, C> resolve() {
        HashMap map = new HashMap();
        this.byItem.forEach((t, i) -> map.put(t, this.getCell((T)i)));
        return map;
    }

    public SequencedMap<Integer, C> getByIndex() {
        return this.byIndex;
    }

    public Map<T, Integer> getByItem() {
        return this.byItem;
    }
}

