/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.utils;

import io.github.palexdev.virtualizedfx.cells.Cell;
import io.github.palexdev.virtualizedfx.utils.CellsQueue;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public class VFXCellsCache<T, C extends Cell<T>> {
    private Function<T, C> cellFactory;
    private final CellsQueue<T, C> queue = new CellsQueue(0);

    public VFXCellsCache(Function<T, C> cellFactory) {
        this.cellFactory = cellFactory;
    }

    public VFXCellsCache(Function<T, C> cellFactory, int capacity) {
        this.cellFactory = cellFactory;
        this.queue.setCapacity(capacity);
    }

    public VFXCellsCache<T, C> populate() {
        if (this.queue.size() == this.queue.getCapacity()) {
            return this;
        }
        if (this.cellFactory == null) {
            throw new NullPointerException("Cannot populate cache as the cell factory is null");
        }
        do {
            Cell c = (Cell)this.cellFactory.apply(null);
            this.queue.add(c);
        } while (this.queue.size() != this.queue.getCapacity());
        return this;
    }

    @SafeVarargs
    public final VFXCellsCache<T, C> cache(C ... cells) {
        for (C c : cells) {
            if (!this.queue.add(c)) continue;
            c.onCache();
        }
        return this;
    }

    public VFXCellsCache<T, C> cache(Collection<C> cells) {
        for (Cell c : cells) {
            if (!this.queue.add(c)) continue;
            c.onCache();
        }
        return this;
    }

    public C take() {
        Cell c = (Cell)this.queue.poll();
        if (c != null) {
            c.onDeCache();
        }
        return (C)c;
    }

    public Optional<C> tryTake() {
        return Optional.ofNullable(this.take());
    }

    public VFXCellsCache<T, C> remove(C cell) {
        boolean removed = this.queue.remove(cell);
        if (removed) {
            cell.dispose();
        }
        return this;
    }

    public VFXCellsCache<T, C> clear() {
        this.queue.forEach(Cell::dispose);
        this.queue.clear();
        return this;
    }

    public int size() {
        return this.queue.size();
    }

    public VFXCellsCache<T, C> setCapacity(int capacity) {
        this.queue.setCapacity(capacity);
        return this;
    }

    public Function<T, C> getCellFactory() {
        return this.cellFactory;
    }

    public void setCellFactory(Function<T, C> cellFactory) {
        this.cellFactory = cellFactory;
    }
}

