/*
 * Decompiled with CFR 0.152.
 */
package com.github.pelenthium.spring.dialect;

import com.github.pelenthium.spring.dialect.ClickhouseDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Optional;
import org.springframework.data.jdbc.repository.config.DialectResolver;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.jdbc.core.JdbcOperations;

public class ClickhouseDialectResolver
implements DialectResolver.JdbcDialectProvider {
    public Optional<Dialect> getDialect(JdbcOperations operations) {
        return Optional.ofNullable((Dialect)operations.execute(this::getDialect));
    }

    private Dialect getDialect(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String name = metaData.getDatabaseProductName().toLowerCase();
        if (name.contains("clickhouse")) {
            return ClickhouseDialect.INSTANCE;
        }
        return null;
    }
}

