/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SpringBootInfrastructurePreInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
BeanDefinitionRegistryPostProcessor,
PriorityOrdered {
    public static final String BEAN_NAME = SpringBootInfrastructurePreInitializer.class.getName();
    private ConfigurableApplicationContext applicationContext;
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private ConfigurableListableBeanFactory beanFactory;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.preInitialize(applicationContext);
        this.registerInfrastructures();
        this.registerMySelf();
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        this.initInfrastructures();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    protected void preInitialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        this.applicationContext = applicationContext;
        this.beanFactory = beanFactory;
        this.beanDefinitionRegistry = beanFactory instanceof BeanDefinitionRegistry ? (BeanDefinitionRegistry)beanFactory : (BeanDefinitionRegistry)applicationContext;
    }

    protected void registerInfrastructures() {
        String registrarClassName = "org.springframework.boot.context.properties.EnableConfigurationPropertiesRegistrar";
        Class registrarClass = ClassUtils.resolveClassName((String)registrarClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
        Method staticMethod = ReflectionUtils.findMethod((Class)registrarClass, (String)"registerInfrastructureBeans", (Class[])new Class[]{BeanDefinitionRegistry.class});
        Assert.notNull((Object)staticMethod, (String)String.format("No method named '%s' found in %s!", "registerInfrastructureBeans", registrarClassName));
        staticMethod.setAccessible(true);
        ReflectionUtils.invokeMethod((Method)staticMethod, null, (Object[])new Object[]{this.beanDefinitionRegistry});
        staticMethod = ReflectionUtils.findMethod((Class)registrarClass, (String)"registerMethodValidationExcludeFilter", (Class[])new Class[]{BeanDefinitionRegistry.class});
        Assert.notNull((Object)staticMethod, (String)String.format("No method named '%s' found in %s!", "registerMethodValidationExcludeFilter", registrarClassName));
        staticMethod.setAccessible(true);
        ReflectionUtils.invokeMethod((Method)staticMethod, null, (Object[])new Object[]{this.beanDefinitionRegistry});
    }

    protected void registerMySelf() {
        AbstractBeanDefinition thisBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(SpringBootInfrastructurePreInitializer.class, () -> this).getBeanDefinition();
        this.beanDefinitionRegistry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)thisBeanDefinition);
    }

    protected void initInfrastructures() {
        this.beanFactory.addBeanPostProcessor((BeanPostProcessor)this.beanFactory.getBean(ConfigurationPropertiesBindingPostProcessor.BEAN_NAME, ConfigurationPropertiesBindingPostProcessor.class));
    }

    public final int getOrder() {
        return Integer.MIN_VALUE;
    }

    protected ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected BeanDefinitionRegistry getBeanDefinitionRegistry() {
        return this.beanDefinitionRegistry;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }
}

