/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.mds.EnableMultiDataSource;
import org.springframework.boot.autoconfigure.mds.MdsComponentBean;
import org.springframework.boot.autoconfigure.mds.MdsComponentBeans;
import org.springframework.boot.autoconfigure.mds.MdsComponentsRegistrationLifecycle;
import org.springframework.boot.autoconfigure.mds.jdbc.MdsJdbcComponentType;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class AbstractMdsComponentsRegistry
implements BeanFactoryAware,
EnvironmentAware,
ResourceLoaderAware,
Ordered {
    protected ListableBeanFactory beanFactory;
    protected ConfigurableEnvironment environment;
    protected ResourceLoader resourceLoader;

    public void registerBeanDefinitions(AnnotationMetadata mdsAnnotationMetadata, BeanDefinitionRegistry registry, MdsComponentBeans mdsComponentBeans) {
        AnnotationAttributes[] databaseAttributesArray;
        AnnotationAttributes componentAttributes = AnnotationAttributes.fromMap((Map)mdsAnnotationMetadata.getAnnotationAttributes(EnableMultiDataSource.class.getName()));
        if (componentAttributes != null && (databaseAttributesArray = componentAttributes.getAnnotationArray("value")).length > 0) {
            for (AnnotationAttributes databaseAttributes : databaseAttributesArray) {
                String database = databaseAttributes.getString("value");
                Set<MdsComponentBean> databasedComponentBeans = this.registerComponentBeans(registry, database);
                mdsComponentBeans.merge(database, databasedComponentBeans, (olds, news) -> {
                    olds.addAll(news);
                    return olds;
                });
            }
            this.postComponentsRegistered(registry, mdsComponentBeans);
            this.afterComponentsRegisterCompletion(mdsAnnotationMetadata, registry, mdsComponentBeans);
        }
    }

    protected abstract Set<MdsComponentBean> registerComponentBeans(BeanDefinitionRegistry var1, String var2);

    protected void postComponentsRegistered(BeanDefinitionRegistry registry, MdsComponentBeans mdsComponentBeans) {
    }

    protected abstract void afterComponentsRegisterCompletion(AnnotationMetadata var1, BeanDefinitionRegistry var2, MdsComponentBeans var3);

    protected boolean hasRequiredDataSource(String database) {
        return this.beanFactory.containsBean(MdsJdbcComponentType.DATASOURCE.getComponentBeanName(database));
    }

    protected <T> BeanDefinition createBindableBeanDefinition(Class<T> beanClass, String bindName) {
        Assert.notNull(beanClass, (String)"Parameter 'beanClass' must be required!");
        Assert.hasText((String)bindName, (String)"Parameter 'bindName' must be required!");
        Object bindObject = Binder.get((Environment)this.environment).bind(bindName, beanClass).orElseThrow(IllegalStateException::new);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanClass, () -> bindObject);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    protected <T> BeanDefinition createBindableBeanDefinition(T beanInstance, Class<T> beanClass, String bindName) {
        Assert.notNull(beanInstance, (String)"Parameter 'beanInstance' must be required!");
        Assert.hasText((String)bindName, (String)"Parameter 'bindName' must be required!");
        Object bindObject = Binder.get((Environment)this.environment).bind(bindName, Bindable.ofInstance(beanInstance)).orElse(beanInstance);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanClass != null ? beanClass : beanInstance.getClass(), () -> bindObject);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    protected <T> BeanDefinition createBeanDefinition(T beanInstance, Class<T> beanClass) {
        Assert.notNull(beanInstance, (String)"Parameter 'beanInstance' must be required!");
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanClass != null ? beanClass : beanInstance.getClass(), () -> beanInstance);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    protected List<MdsComponentsRegistrationLifecycle> getMdsComponentsRegistrationLifecycles() {
        return this.beanFactory.getBeanProvider(MdsComponentsRegistrationLifecycle.class).orderedStream().collect(Collectors.toList());
    }

    protected Set<MdsComponentBean> newComponentBeans() {
        return new LinkedHashSet<MdsComponentBean>();
    }

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public final void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public final void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

