/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds;

import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.core.annotation.Order;

@Order
public class ExcludeDefaultAutoConfigurationFilter
implements AutoConfigurationImportFilter {
    private static final Set<String> EXCLUDE_AUTO_CONFIGURATIONS = new HashSet<String>();

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        int length = autoConfigurationClasses.length;
        boolean[] imports = new boolean[length];
        for (int i = 0; i < length; ++i) {
            imports[i] = !EXCLUDE_AUTO_CONFIGURATIONS.contains(autoConfigurationClasses[i]);
        }
        return imports;
    }

    static {
        EXCLUDE_AUTO_CONFIGURATIONS.add("org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration");
        EXCLUDE_AUTO_CONFIGURATIONS.add("org.springframework.boot.autoconfigure.jdbc.JndiDataSourceAutoConfiguration");
        EXCLUDE_AUTO_CONFIGURATIONS.add("org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration");
        EXCLUDE_AUTO_CONFIGURATIONS.add("com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration");
        EXCLUDE_AUTO_CONFIGURATIONS.add("org.apache.shardingsphere.spring.boot.ShardingSphereAutoConfiguration");
        EXCLUDE_AUTO_CONFIGURATIONS.add("org.apache.shardingsphere.sharding.spring.boot.ShardingRuleSpringBootConfiguration");
    }
}

