/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds;

import java.util.Objects;
import org.springframework.boot.autoconfigure.mds.MdsComponentType;
import org.springframework.util.StringUtils;

public class MdsComponentBean {
    private final String database;
    private final MdsComponentType componentType;
    private final String componentBeanName;
    private final Object componentBean;
    private final boolean autoCreated;

    public MdsComponentBean(MdsComponentType componentType, String componentBeanName, Object componentBean, boolean autoCreated) {
        this(null, componentType, componentBeanName, componentBean, autoCreated);
    }

    public MdsComponentBean(String database, MdsComponentType componentType, String componentBeanName, Object componentBean, boolean autoCreated) {
        this.database = database;
        this.componentType = componentType;
        this.componentBeanName = componentBeanName;
        this.componentBean = componentBean;
        this.autoCreated = autoCreated;
    }

    public String getDatabase() {
        return this.database;
    }

    public MdsComponentType getComponentType() {
        return this.componentType;
    }

    public String getComponentBeanName() {
        return this.componentBeanName;
    }

    public <T> T getComponentBean() {
        return (T)this.componentBean;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MdsComponentBean)) {
            return false;
        }
        MdsComponentBean that = (MdsComponentBean)o;
        return Objects.equals(this.componentBeanName, that.componentBeanName);
    }

    public int hashCode() {
        return Objects.hash(this.componentBeanName);
    }

    public String toString() {
        return StringUtils.hasText((String)this.database) ? this.componentBeanName + "@" + this.database : this.componentBeanName;
    }
}

