/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.mds.jdbc.MdsJdbcComponentType;
import org.springframework.boot.autoconfigure.mds.jdbc.MdsJdbcComponentsBuilder;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.util.StringUtils;

public class DefaultMdsJdbcComponentsBuilder
extends MdsJdbcComponentsBuilder {
    @Override
    public DataSource buildDataSource(String database, DataSourceProperties properties) {
        if (StringUtils.hasText((String)properties.getJndiName())) {
            return this.buildJndiDataSource(database, properties);
        }
        return this.buildPooledDataSource(database, properties);
    }

    protected DataSource buildPooledDataSource(String database, DataSourceProperties properties) {
        HikariDataSource dataSource = (HikariDataSource)this.createDataSource(properties, HikariDataSource.class);
        dataSource.setPoolName(database + "HikariPool");
        return dataSource;
    }

    protected DataSource buildJndiDataSource(String database, DataSourceProperties properties) {
        JndiDataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
        DataSource dataSource = dataSourceLookup.getDataSource(properties.getJndiName());
        this.excludeMBeanIfNecessary(dataSource, MdsJdbcComponentType.DATASOURCE.getComponentBeanName(database));
        return dataSource;
    }

    @Override
    protected String getPoolTypeName(String database, DataSourceProperties properties) {
        return StringUtils.hasText((String)properties.getJndiName()) ? null : "hikari";
    }
}

