/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.jdbc;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcProperties;
import org.springframework.boot.autoconfigure.mds.AbstractMdsComponentsRegistry;
import org.springframework.boot.autoconfigure.mds.MdsComponentBean;
import org.springframework.boot.autoconfigure.mds.MdsComponentBeans;
import org.springframework.boot.autoconfigure.mds.jdbc.MdsJdbcComponentConfig;
import org.springframework.boot.autoconfigure.mds.jdbc.MdsJdbcComponentType;
import org.springframework.boot.autoconfigure.mds.jdbc.MdsJdbcComponentsBuilder;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.transaction.ChainedTransactionManager;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.JdbcTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MdsJdbcComponentsRegistry
extends AbstractMdsComponentsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdsJdbcComponentsRegistry.class);
    protected final MdsJdbcComponentsBuilder mdsJdbcComponentsBuilder;

    public MdsJdbcComponentsRegistry(MdsJdbcComponentsBuilder mdsJdbcComponentsBuilder) {
        this.mdsJdbcComponentsBuilder = mdsJdbcComponentsBuilder;
    }

    @Override
    protected Set<MdsComponentBean> registerComponentBeans(BeanDefinitionRegistry registry, String database) {
        Set<MdsComponentBean> componentBeans = this.newComponentBeans();
        String dataSourceBeanName = MdsJdbcComponentType.DATASOURCE.getComponentBeanName(database);
        DataSourceProperties dataSourceProperties = (DataSourceProperties)MdsJdbcComponentConfig.DATASOURCE.getBoundedConfigProperties((Environment)this.environment, database);
        if (!this.beanFactory.containsBean(dataSourceBeanName) && dataSourceProperties == null) {
            throw new IllegalStateException(String.format("Can not determine the DataSource bean(%s) for @NamedDatabase(\"%s\"), please check your configuration!", dataSourceBeanName, database));
        }
        LOGGER.debug("Prepare to dynamic register Multi-DataSource Jdbc components for Database({}).", (Object)database);
        componentBeans.addAll(this.registerDataSource(registry, database, dataSourceProperties));
        componentBeans.addAll(this.registerJdbcTemplate(registry, database));
        componentBeans.addAll(this.registerTransactionManager(registry, database));
        return componentBeans;
    }

    @Override
    protected void afterComponentsRegisterCompletion(AnnotationMetadata mdsAnnotationMetadata, BeanDefinitionRegistry registry, MdsComponentBeans mdsComponentBeans) {
        this.getMdsComponentsRegistrationLifecycles().forEach(lifecycle -> lifecycle.onMdsJdbcComponentsRegistered(mdsAnnotationMetadata, registry, mdsComponentBeans.clone()));
    }

    protected Set<MdsComponentBean> registerDataSource(BeanDefinitionRegistry registry, String database, DataSourceProperties dataSourceProperties) {
        Set<MdsComponentBean> componentBeans = this.newComponentBeans();
        String dataSourceBeanName = MdsJdbcComponentType.DATASOURCE.getComponentBeanName(database);
        boolean componentExist = this.beanFactory.containsBean(dataSourceBeanName);
        if (!componentExist) {
            BeanDefinition dataSourcePropertiesDefinition = this.createBeanDefinition(dataSourceProperties, MdsJdbcComponentType.DATASOURCE_PROPERTIES.getComponentBeanType());
            String dataSourcePropertiesBeanName = MdsJdbcComponentType.DATASOURCE_PROPERTIES.getComponentBeanName(database);
            registry.registerBeanDefinition(dataSourcePropertiesBeanName, dataSourcePropertiesDefinition);
            dataSourceProperties = (DataSourceProperties)this.beanFactory.getBean(dataSourcePropertiesBeanName, MdsJdbcComponentType.DATASOURCE_PROPERTIES.getComponentBeanType());
            componentBeans.add(new MdsComponentBean(database, MdsJdbcComponentType.DATASOURCE_PROPERTIES, dataSourcePropertiesBeanName, dataSourceProperties, true));
            LOGGER.debug("Dynamic register DataSourceProperties[database = {}] bean ({}) successfully: {}", new Object[]{database, dataSourcePropertiesBeanName, dataSourceProperties});
            DataSource dataSource = this.mdsJdbcComponentsBuilder.buildDataSource(database, dataSourceProperties);
            String poolTypeName = this.mdsJdbcComponentsBuilder.getPoolTypeName(database, dataSourceProperties);
            BeanDefinition dataSourceDefinition = StringUtils.hasText((String)poolTypeName) ? this.createBindableBeanDefinition(dataSource, MdsJdbcComponentType.DATASOURCE.getComponentBeanType(), MdsJdbcComponentConfig.DATASOURCE.getConfigPrefixOf(poolTypeName)) : this.createBeanDefinition(dataSource, MdsJdbcComponentType.DATASOURCE.getComponentBeanType());
            registry.registerBeanDefinition(dataSourceBeanName, dataSourceDefinition);
            LOGGER.debug("Dynamic register DataSource[database = {}] bean ({}) successfully: {}", new Object[]{database, dataSourceBeanName, dataSource});
        }
        componentBeans.add(new MdsComponentBean(database, MdsJdbcComponentType.DATASOURCE, dataSourceBeanName, this.beanFactory.getBean(dataSourceBeanName, MdsJdbcComponentType.DATASOURCE.getComponentBeanType()), !componentExist));
        return componentBeans;
    }

    protected Set<MdsComponentBean> registerJdbcTemplate(BeanDefinitionRegistry registry, String database) {
        Set<MdsComponentBean> componentBeans = this.newComponentBeans();
        String jdbcTemplateBeanName = MdsJdbcComponentType.JDBC_TEMPLATE.getComponentBeanName(database);
        boolean componentExist = this.beanFactory.containsBean(jdbcTemplateBeanName);
        if (!componentExist) {
            String dataSourceBeanName = MdsJdbcComponentType.DATASOURCE.getComponentBeanName(database);
            DataSource dataSource = (DataSource)this.beanFactory.getBean(dataSourceBeanName, MdsJdbcComponentType.DATASOURCE.getComponentBeanType());
            JdbcTemplate jdbcTemplate = this.createJdbcTemplate(dataSource, database);
            BeanDefinition jdbcTemplateDefinition = this.createBeanDefinition(jdbcTemplate, MdsJdbcComponentType.JDBC_TEMPLATE.getComponentBeanType());
            registry.registerBeanDefinition(jdbcTemplateBeanName, jdbcTemplateDefinition);
            jdbcTemplate = (JdbcTemplate)this.beanFactory.getBean(jdbcTemplateBeanName, MdsJdbcComponentType.JDBC_TEMPLATE.getComponentBeanType());
            LOGGER.debug("Dynamic register JdbcTemplate[database = {}] bean ({}) successfully: {}", new Object[]{database, jdbcTemplateBeanName, jdbcTemplate});
        }
        componentBeans.add(new MdsComponentBean(database, MdsJdbcComponentType.JDBC_TEMPLATE, jdbcTemplateBeanName, this.beanFactory.getBean(jdbcTemplateBeanName, MdsJdbcComponentType.JDBC_TEMPLATE.getComponentBeanType()), !componentExist));
        return componentBeans;
    }

    protected JdbcTemplate createJdbcTemplate(DataSource dataSource, String database) {
        JdbcProperties jdbcProperties = (JdbcProperties)MdsJdbcComponentConfig.JDBC.getBoundedConfigProperties((Environment)this.environment, database);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        JdbcProperties.Template template = jdbcProperties.getTemplate();
        jdbcTemplate.setFetchSize(template.getFetchSize());
        jdbcTemplate.setMaxRows(template.getMaxRows());
        if (template.getQueryTimeout() != null) {
            jdbcTemplate.setQueryTimeout((int)template.getQueryTimeout().getSeconds());
        }
        return jdbcTemplate;
    }

    protected Set<MdsComponentBean> registerTransactionManager(BeanDefinitionRegistry registry, String database) {
        Set<MdsComponentBean> componentBeans = this.newComponentBeans();
        String transactionManagerBeanName = MdsJdbcComponentType.TRANSACTION_MANAGER.getComponentBeanName(database);
        boolean componentExist = this.beanFactory.containsBean(transactionManagerBeanName);
        if (!componentExist) {
            String dataSourceBeanName = MdsJdbcComponentType.DATASOURCE.getComponentBeanName(database);
            DataSource dataSource = (DataSource)this.beanFactory.getBean(dataSourceBeanName, MdsJdbcComponentType.DATASOURCE.getComponentBeanType());
            DataSourceTransactionManager dataSourceTransactionManager = this.createDataSourceTransactionManager(dataSource, database);
            BeanDefinition transactionManagerDefinition = this.createBeanDefinition(dataSourceTransactionManager, MdsJdbcComponentType.TRANSACTION_MANAGER.getComponentBeanType());
            registry.registerBeanDefinition(transactionManagerBeanName, transactionManagerDefinition);
            LOGGER.debug("Dynamic register DataSourceTransactionManager[database = {}] bean ({}) successfully: {}", new Object[]{database, transactionManagerBeanName, dataSourceTransactionManager});
        }
        componentBeans.add(new MdsComponentBean(database, MdsJdbcComponentType.TRANSACTION_MANAGER, transactionManagerBeanName, this.beanFactory.getBean(transactionManagerBeanName, MdsJdbcComponentType.TRANSACTION_MANAGER.getComponentBeanType()), !componentExist));
        return componentBeans;
    }

    protected DataSourceTransactionManager createDataSourceTransactionManager(DataSource dataSource, String database) {
        return (Boolean)this.environment.getProperty("spring.dao.exceptiontranslation.enabled", Boolean.class, (Object)Boolean.TRUE) != false ? new JdbcTransactionManager(dataSource) : new DataSourceTransactionManager(dataSource);
    }

    protected MdsComponentBean registerDefaultTransactionManager(BeanDefinitionRegistry registry, List<MdsComponentBean> transactionManagerBeans) {
        String defaultTransactionManagerBeanName = "allTransactionManager";
        transactionManagerBeans.sort(Comparator.comparing(MdsComponentBean::getComponentBeanName, String::compareTo));
        if (transactionManagerBeans.size() > 1) {
            List databases = transactionManagerBeans.stream().map(MdsComponentBean::getDatabase).collect(Collectors.toList());
            PlatformTransactionManager[] multiTransactionManagers = (PlatformTransactionManager[])transactionManagerBeans.stream().map(component -> (PlatformTransactionManager)component.getComponentBean()).toArray(PlatformTransactionManager[]::new);
            ChainedTransactionManager defaultTransactionManager = new ChainedTransactionManager(multiTransactionManagers);
            BeanDefinition defaultTransactionManagerBeanDefinition = this.createBeanDefinition(defaultTransactionManager, ChainedTransactionManager.class);
            registry.registerBeanDefinition(defaultTransactionManagerBeanName, defaultTransactionManagerBeanDefinition);
            LOGGER.debug("Dynamic register default TransactionManager {}[databases = {}] bean (allTransactionManager) successfully: {}", new Object[]{defaultTransactionManager.getClass().getSimpleName(), databases, defaultTransactionManager});
        } else {
            MdsComponentBean defaultTransactionManagerBean = transactionManagerBeans.get(0);
            registry.registerAlias(defaultTransactionManagerBean.getComponentBeanName(), defaultTransactionManagerBeanName);
            LOGGER.debug("Dynamic register default TransactionManager {}[databases = {}] bean (allTransactionManager) successfully: {}", new Object[]{defaultTransactionManagerBean.getComponentBean().getClass().getSimpleName(), defaultTransactionManagerBean.getDatabase(), defaultTransactionManagerBean.getComponentBean()});
        }
        return new MdsComponentBean(MdsJdbcComponentType.TRANSACTION_MANAGER, defaultTransactionManagerBeanName, this.beanFactory.getBean(defaultTransactionManagerBeanName, PlatformTransactionManager.class), true);
    }

    @Override
    protected void postComponentsRegistered(BeanDefinitionRegistry registry, MdsComponentBeans mdsComponentBeans) {
        super.postComponentsRegistered(registry, mdsComponentBeans);
        List<MdsComponentBean> transactionManagerBeans = mdsComponentBeans.values().stream().flatMap(Collection::stream).filter(component -> MdsJdbcComponentType.TRANSACTION_MANAGER.equals(component.getComponentType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(transactionManagerBeans)) {
            mdsComponentBeans.setDefaultTransactionManager(this.registerDefaultTransactionManager(registry, transactionManagerBeans));
        }
    }

    public final int getOrder() {
        return 2147481647;
    }
}

