/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mds.mybatis;

import java.util.Map;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.springframework.boot.autoconfigure.mds.MdsComponentConfig;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public enum MdsMybatisComponentConfig implements MdsComponentConfig
{
    MYBATIS("mybatis", (Class)MybatisProperties.class){

        public MybatisProperties getBoundedConfigProperties(Environment environment, String database) {
            String configPrefix = this.getConfigPrefix() + (StringUtils.hasText((String)database) ? "." + database : "");
            MybatisProperties configProperties = (MybatisProperties)this.bindConfigProperties(environment, configPrefix);
            if (StringUtils.hasText((String)configProperties.getConfigLocation()) || !ObjectUtils.isEmpty((Object[])configProperties.getMapperLocations()) || !CollectionUtils.isEmpty((Map)configProperties.getConfigurationProperties()) || StringUtils.hasText((String)configProperties.getTypeAliasesPackage()) || configProperties.getTypeAliasesSuperType() != null || StringUtils.hasText((String)configProperties.getTypeHandlersPackage()) || configProperties.getDefaultScriptingLanguageDriver() != null || configProperties.getExecutorType() != null || configProperties.getConfiguration() != null || configProperties.isCheckConfigLocation()) {
                return configProperties;
            }
            return null;
        }

        public MybatisProperties newDefaultConfigProperties() {
            return new MybatisProperties();
        }
    };

    private final String configPrefix;
    private final Class<?> configPropertiesType;

    private MdsMybatisComponentConfig(String configPrefix, Class<?> configPropertiesType) {
        this.configPrefix = configPrefix;
        this.configPropertiesType = configPropertiesType;
    }

    @Override
    public String getConfigPrefix() {
        return this.configPrefix;
    }

    @Override
    public Class<?> getConfigPropertiesType() {
        return this.configPropertiesType;
    }
}

