/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.annotation.EnableMultiTransactionManagement;
import org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.MultiTransactionInterceptor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
public class ProxyMultiTransactionManagementConfiguration
extends AbstractTransactionManagementConfiguration {
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableTx = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableMultiTransactionManagement.class.getName(), false));
        if (this.enableTx == null) {
            throw new IllegalArgumentException("@EnableMultiTransactionManagement is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Bean(name={"org.springframework.transaction.config.internalTransactionAdvisor"})
    @Role(value=2)
    public BeanFactoryTransactionAttributeSourceAdvisor transactionAdvisor(TransactionAttributeSource transactionAttributeSource, TransactionInterceptor transactionInterceptor) {
        BeanFactoryTransactionAttributeSourceAdvisor advisor = new BeanFactoryTransactionAttributeSourceAdvisor();
        advisor.setTransactionAttributeSource(transactionAttributeSource);
        advisor.setAdvice((Advice)transactionInterceptor);
        if (this.enableTx != null) {
            advisor.setOrder(((Integer)this.enableTx.getNumber("order")).intValue());
        }
        return advisor;
    }

    @Bean
    @Role(value=2)
    public TransactionAttributeSource transactionAttributeSource() {
        return new AnnotationTransactionAttributeSource();
    }

    @Bean
    @Role(value=2)
    public TransactionInterceptor transactionInterceptor(TransactionAttributeSource transactionAttributeSource) {
        return new MultiTransactionInterceptor(transactionAttributeSource);
    }
}

