/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.util.StringUtils;

public abstract class RSQLVisitorBase<R, A>
implements RSQLVisitor<R, A> {
    private static final Logger log = LoggerFactory.getLogger(RSQLVisitorBase.class);
    protected static volatile Map<Class, ManagedType> managedTypeMap;
    protected static volatile Map<String, EntityManager> entityManagerMap;
    protected static final Map<Class, Class> primitiveToWrapper;
    protected static volatile Map<Class<?>, Map<String, String>> propertyRemapping;
    protected static volatile Map<Class<?>, List<String>> propertyWhitelist;
    protected static volatile Map<Class<?>, List<String>> propertyBlacklist;
    protected static volatile ConfigurableConversionService defaultConversionService;

    protected Map<Class, ManagedType> getManagedTypeMap() {
        return managedTypeMap != null ? managedTypeMap : Collections.emptyMap();
    }

    protected Map<String, EntityManager> getEntityManagerMap() {
        return entityManagerMap != null ? entityManagerMap : Collections.emptyMap();
    }

    protected abstract Map<String, String> getPropertyPathMapper();

    public Map<Class<?>, Map<String, String>> getPropertyRemapping() {
        return propertyRemapping != null ? propertyRemapping : Collections.emptyMap();
    }

    protected Object convert(String source, Class targetType) {
        log.debug("convert(source:{},targetType:{})", (Object)source, (Object)targetType);
        Object object = null;
        try {
            if (defaultConversionService.canConvert(String.class, targetType)) {
                object = defaultConversionService.convert((Object)source, targetType);
            } else if (targetType.equals(String.class)) {
                object = source;
            } else if (targetType.equals(UUID.class)) {
                object = UUID.fromString(source);
            } else if (targetType.equals(java.util.Date.class) || targetType.equals(Date.class)) {
                object = Date.valueOf(LocalDate.parse(source));
            } else if (targetType.equals(LocalDate.class)) {
                object = LocalDate.parse(source);
            } else if (targetType.equals(LocalDateTime.class)) {
                object = LocalDateTime.parse(source);
            } else if (targetType.equals(OffsetDateTime.class)) {
                object = OffsetDateTime.parse(source);
            } else if (targetType.equals(ZonedDateTime.class)) {
                object = ZonedDateTime.parse(source);
            } else if (targetType.equals(Character.class)) {
                object = !StringUtils.isEmpty((Object)source) ? Character.valueOf(source.charAt(0)) : null;
            } else if (targetType.equals(Boolean.TYPE) || targetType.equals(Boolean.class)) {
                object = Boolean.valueOf(source);
            } else if (targetType.isEnum()) {
                object = Enum.valueOf(targetType, source);
            } else {
                Constructor cons = targetType.getConstructor(String.class);
                object = cons.newInstance(source);
            }
            return object;
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            log.debug("Parsing [{}] with [{}] causing [{}], skip", new Object[]{source, targetType.getName(), e.getMessage()});
        }
        catch (Exception e) {
            log.error("Parsing [{}] with [{}] causing [{}], add your parser via RSQLSupport.addConverter(Type.class, Type::valueOf)", new Object[]{source, targetType.getName(), e.getMessage(), e});
        }
        return null;
    }

    protected void accessControl(Class type, String name) {
        log.debug("accessControl(type:{},name:{})", (Object)type, (Object)name);
        if (propertyWhitelist != null && propertyWhitelist.containsKey(type) && !propertyWhitelist.get(type).contains(name)) {
            throw new IllegalArgumentException("Property " + type.getName() + "." + name + " is not on whitelist");
        }
        if (propertyBlacklist != null && propertyBlacklist.containsKey(type) && propertyBlacklist.get(type).contains(name)) {
            throw new IllegalArgumentException("Property " + type.getName() + "." + name + " is on blacklist");
        }
    }

    protected String mapPropertyPath(String propertyPath) {
        String property;
        if (!this.getPropertyPathMapper().isEmpty() && StringUtils.hasText((String)(property = this.getPropertyPathMapper().get(propertyPath)))) {
            log.debug("Map propertyPath [{}] to [{}]", (Object)propertyPath, (Object)property);
            return property;
        }
        return propertyPath;
    }

    protected String mapProperty(String selector, Class<?> entityClass) {
        if (!this.getPropertyRemapping().isEmpty()) {
            String property;
            Map<String, String> map = this.getPropertyRemapping().get(entityClass);
            String string = property = map != null ? map.get(selector) : null;
            if (StringUtils.hasText((String)property)) {
                log.debug("Map property [{}] to [{}] for [{}]", new Object[]{selector, property, entityClass});
                return property;
            }
        }
        return selector;
    }

    protected <T> Class<?> findPropertyType(String property, ManagedType<T> classMetadata) {
        Class propertyType = null;
        propertyType = classMetadata.getAttribute(property).isCollection() ? ((PluralAttribute)classMetadata.getAttribute(property)).getBindableJavaType() : classMetadata.getAttribute(property).getJavaType();
        return propertyType;
    }

    protected <T> ManagedType<T> getManagedType(Class<T> cls) {
        Exception ex = null;
        if (this.getEntityManagerMap().size() > 0) {
            ManagedType managedType = this.getManagedTypeMap().get(cls);
            if (managedType != null) {
                log.debug("Found managed type [{}] in cache", cls);
                return managedType;
            }
            for (Map.Entry<String, EntityManager> entityManagerEntry : this.getEntityManagerMap().entrySet()) {
                try {
                    managedType = entityManagerEntry.getValue().getMetamodel().managedType(cls);
                    this.getManagedTypeMap().put(cls, managedType);
                    log.debug("Found managed type [{}] in EntityManager [{}]", cls, (Object)entityManagerEntry.getKey());
                    return managedType;
                }
                catch (Exception e) {
                    if (e != null) {
                        ex = e;
                    }
                    log.debug("[{}] not found in EntityManager [{}] due to [{}]", new Object[]{cls, entityManagerEntry.getKey(), e == null ? "-" : e.getMessage()});
                }
            }
        }
        log.error("[{}] not found in EntityManager{}: [{}]", new Object[]{cls, this.getEntityManagerMap().size() > 1 ? "s" : "", StringUtils.collectionToCommaDelimitedString(this.getEntityManagerMap().keySet())});
        throw ex != null ? ex : new IllegalStateException("No entity manager bean found in application context");
    }

    protected <T> ManagedType<T> getManagedElementCollectionType(String mappedProperty, ManagedType<T> classMetadata) {
        try {
            Class<?> cls = this.findPropertyType(mappedProperty, classMetadata);
            if (!(cls.isPrimitive() || primitiveToWrapper.containsValue(cls) || cls.equals(String.class) || this.getEntityManagerMap().size() <= 0)) {
                ManagedType managedType = this.getManagedTypeMap().get(cls);
                if (managedType != null) {
                    log.debug("Found managed type [{}] in cache", cls);
                    return managedType;
                }
                Iterator<Map.Entry<String, EntityManager>> iterator = this.getEntityManagerMap().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, EntityManager> entityManagerEntry = iterator.next();
                    managedType = entityManagerEntry.getValue().getMetamodel().managedType(cls);
                    this.getManagedTypeMap().put(cls, managedType);
                    log.info("Found managed type [{}] in EntityManager [{}]", cls, (Object)entityManagerEntry.getKey());
                    return managedType;
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to get the managed type of [{}]", (Object)mappedProperty, (Object)e);
        }
        return classMetadata;
    }

    protected <T> boolean hasPropertyName(String property, ManagedType<T> classMetadata) {
        Set names = classMetadata.getAttributes();
        for (Attribute name : names) {
            if (!name.getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    protected Class getElementCollectionGenericType(Class type, Attribute attribute) {
        Field field;
        Type genericType;
        Member member = attribute.getJavaMember();
        if (member instanceof Field && (genericType = (field = (Field)member).getGenericType()) instanceof ParameterizedType) {
            ParameterizedType rawType = (ParameterizedType)genericType;
            Class<?> elementCollectionClass = Class.forName(rawType.getActualTypeArguments()[0].getTypeName());
            log.info("Map element collection generic type [{}] to [{}]", (Object)attribute.getName(), elementCollectionClass);
            return elementCollectionClass;
        }
        return type;
    }

    protected <T> boolean isEmbeddedType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
    }

    protected <T> boolean isElementCollectionType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
    }

    protected <T> boolean isAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation();
    }

    protected <T> boolean isOneToOneAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation() && Attribute.PersistentAttributeType.ONE_TO_ONE == classMetadata.getAttribute(property).getPersistentAttributeType();
    }

    protected <T> boolean isOneToManyAssociationType(String property, ManagedType<T> classMetadata) {
        return classMetadata.getAttribute(property).isAssociation() && Attribute.PersistentAttributeType.ONE_TO_MANY == classMetadata.getAttribute(property).getPersistentAttributeType();
    }

    public static void setManagedTypeMap(Map<Class, ManagedType> managedTypeMap) {
        RSQLVisitorBase.managedTypeMap = managedTypeMap;
    }

    public static void setEntityManagerMap(Map<String, EntityManager> entityManagerMap) {
        RSQLVisitorBase.entityManagerMap = entityManagerMap;
    }

    public static void setPropertyRemapping(Map<Class<?>, Map<String, String>> propertyRemapping) {
        RSQLVisitorBase.propertyRemapping = propertyRemapping;
    }

    public static void setPropertyWhitelist(Map<Class<?>, List<String>> propertyWhitelist) {
        RSQLVisitorBase.propertyWhitelist = propertyWhitelist;
    }

    public static void setPropertyBlacklist(Map<Class<?>, List<String>> propertyBlacklist) {
        RSQLVisitorBase.propertyBlacklist = propertyBlacklist;
    }

    public static void setDefaultConversionService(ConfigurableConversionService defaultConversionService) {
        RSQLVisitorBase.defaultConversionService = defaultConversionService;
    }

    static {
        HashMap<Class<Object>, Class<Void>> map = new HashMap<Class<Object>, Class<Void>>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        map.put(Void.TYPE, Void.class);
        primitiveToWrapper = Collections.unmodifiableMap(map);
    }
}

