/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class PathUtils {
    private PathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Optional<String> findMappingOnBeginning(String path, Map<String, String> mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return Optional.empty();
        }
        return mapping.entrySet().stream().filter(entry -> path.startsWith((String)entry.getKey())).filter(entry -> StringUtils.hasText((String)((String)entry.getValue()))).map(entry -> (String)entry.getValue() + path.substring(((String)entry.getKey()).length())).findFirst();
    }

    public static Optional<String> findMappingOnWhole(String path, Map<String, String> mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return Optional.empty();
        }
        return mapping.entrySet().stream().filter(entry -> Objects.equals(path, entry.getKey())).filter(entry -> StringUtils.hasText((String)((String)entry.getValue()))).map(Map.Entry::getValue).findFirst();
    }

    public static String expectBestMapping(String path, Map<String, String> mapping) {
        return PathUtils.findMappingOnWhole(path, mapping).or(() -> PathUtils.findMappingOnBeginning(path, mapping)).orElse(path);
    }
}

