/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import io.github.perplexhub.rsql.RSQLCommonSupport;
import io.github.perplexhub.rsql.RSQLJPASupport;
import jakarta.persistence.EntityManager;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.orm.jpa.vendor.Database;

@Configuration
@ConditionalOnClass(value={EntityManager.class})
@Import(value={HibernateEntityManagerDatabaseConfiguration.class})
public class RSQLJPAAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RSQLJPAAutoConfiguration.class);

    @Bean
    public RSQLCommonSupport rsqlCommonSupport(Map<String, EntityManager> entityManagerMap, ObjectProvider<EntityManagerDatabase> entityManagerDatabaseProvider) {
        log.info("RSQLJPAAutoConfiguration.rsqlCommonSupport(entityManagerMap:{})", (Object)entityManagerMap.size());
        EntityManagerDatabase entityManagerDatabase = (EntityManagerDatabase)entityManagerDatabaseProvider.getIfAvailable(() -> new EntityManagerDatabase(Map.of()));
        return new RSQLJPASupport(entityManagerMap, entityManagerDatabase.value());
    }

    record EntityManagerDatabase(Map<EntityManager, Database> value) {
    }

    @Configuration
    @ConditionalOnClass(value={SessionImplementor.class})
    static class HibernateEntityManagerDatabaseConfiguration {
        HibernateEntityManagerDatabaseConfiguration() {
        }

        @Bean
        public EntityManagerDatabase entityManagerDatabase(ObjectProvider<EntityManager> entityManagers) {
            return entityManagers.stream().map(entityManager -> {
                SessionFactory sessionFactory = ((Session)entityManager.unwrap(Session.class)).getSessionFactory();
                Dialect dialect = ((SessionFactoryImpl)sessionFactory).getJdbcServices().getDialect();
                return Optional.ofNullable(this.toDatabase(dialect)).map(db -> Map.entry(entityManager, db)).orElse(null);
            }).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (db1, db2) -> db1, IdentityHashMap::new), EntityManagerDatabase::new));
        }

        private Database toDatabase(Dialect dialect) {
            if (dialect instanceof PostgreSQLDialect || dialect instanceof CockroachDialect) {
                return Database.POSTGRESQL;
            }
            if (dialect instanceof MySQLDialect) {
                return Database.MYSQL;
            }
            if (dialect instanceof SQLServerDialect) {
                return Database.SQL_SERVER;
            }
            if (dialect instanceof OracleDialect) {
                return Database.ORACLE;
            }
            if (dialect instanceof DerbyDialect) {
                return Database.DERBY;
            }
            if (dialect instanceof DB2Dialect) {
                return Database.DB2;
            }
            if (dialect instanceof H2Dialect) {
                return Database.H2;
            }
            if (dialect instanceof AbstractHANADialect) {
                return Database.HANA;
            }
            if (dialect instanceof HSQLDialect) {
                return Database.HSQL;
            }
            if (dialect instanceof SybaseDialect) {
                return Database.SQL_SERVER;
            }
            return null;
        }
    }
}

