/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.RSQLCustomPredicate;
import io.github.perplexhub.rsql.RSQLCustomPredicateInput;
import io.github.perplexhub.rsql.RSQLJPAContext;
import io.github.perplexhub.rsql.RSQLJPASupport;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSQLJPAPredicateConverter
extends RSQLVisitorBase<Predicate, From> {
    private static final Logger log = LoggerFactory.getLogger(RSQLJPAPredicateConverter.class);
    private final CriteriaBuilder builder;
    private final Map<String, Path> cachedJoins = new HashMap<String, Path>();
    private final Map<String, String> propertyPathMapper;
    private final Map<ComparisonOperator, RSQLCustomPredicate<?>> customPredicates;

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper) {
        this(builder, propertyPathMapper, null);
    }

    public RSQLJPAPredicateConverter(CriteriaBuilder builder, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates) {
        this.builder = builder;
        this.propertyPathMapper = propertyPathMapper != null ? propertyPathMapper : Collections.emptyMap();
        this.customPredicates = customPredicates != null ? customPredicates.stream().collect(Collectors.toMap(RSQLCustomPredicate::getOperator, Function.identity(), (a, b) -> a)) : Collections.emptyMap();
    }

    <T> RSQLJPAContext findPropertyPath(String propertyPath, Path startRoot) {
        String[] properties;
        ManagedType classMetadata = this.getManagedType(startRoot.getJavaType());
        Path<?> root = startRoot;
        Class type = startRoot.getJavaType();
        Attribute attribute = null;
        for (String property : properties = propertyPath.split("\\.")) {
            String mappedProperty = this.mapProperty(property, classMetadata.getJavaType());
            if (!mappedProperty.equals(property)) {
                RSQLJPAContext context = this.findPropertyPath(mappedProperty, (Path)root);
                root = context.getPath();
                attribute = context.getAttribute();
                continue;
            }
            if (!this.hasPropertyName(mappedProperty, classMetadata)) {
                if (Modifier.isAbstract(classMetadata.getJavaType().getModifiers())) {
                    Optional<Class> foundSubClass = new Reflections(classMetadata.getJavaType().getPackage().getName(), new Scanner[0]).getSubTypesOf(classMetadata.getJavaType()).stream().filter(subType -> this.hasPropertyName(mappedProperty, this.getManagedType((Class)subType))).findFirst();
                    if (foundSubClass.isPresent()) {
                        classMetadata = this.getManagedType(foundSubClass.get());
                        root = root instanceof Join ? this.builder.treat((Join)root, foundSubClass.get()).get(property) : this.builder.treat((Path)root, foundSubClass.get()).get(property);
                        attribute = classMetadata.getAttribute(property);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown property: " + mappedProperty + " from entity " + classMetadata.getJavaType().getName());
                }
                throw new IllegalArgumentException("Unknown property: " + mappedProperty + " from entity " + classMetadata.getJavaType().getName());
            }
            if (this.isAssociationType(mappedProperty, classMetadata) && !property.equals(propertyPath)) {
                Class associationType;
                boolean isOneToAssociationType = this.isOneToOneAssociationType(mappedProperty, classMetadata) || this.isOneToManyAssociationType(mappedProperty, classMetadata);
                type = associationType = this.findPropertyType(mappedProperty, classMetadata);
                String previousClass = classMetadata.getJavaType().getName();
                classMetadata = this.getManagedType(associationType);
                String keyJoin = root.getJavaType().getSimpleName().concat(".").concat(mappedProperty);
                log.debug("Create a join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = isOneToAssociationType ? this.joinLeft(keyJoin, root, mappedProperty) : this.join(keyJoin, root, mappedProperty);
                continue;
            }
            if (this.isElementCollectionType(mappedProperty, classMetadata)) {
                String previousClass = classMetadata.getJavaType().getName();
                attribute = classMetadata.getAttribute(property);
                classMetadata = this.getManagedElementCollectionType(mappedProperty, classMetadata);
                String keyJoin = root.getJavaType().getSimpleName().concat(".").concat(mappedProperty);
                log.debug("Create a element collection join between [{}] and [{}] using key [{}]", new Object[]{previousClass, classMetadata.getJavaType().getName(), keyJoin});
                root = this.join(keyJoin, root, mappedProperty);
                continue;
            }
            log.debug("Create property path for type [{}] property [{}]", (Object)classMetadata.getJavaType().getName(), (Object)mappedProperty);
            root = root.get(mappedProperty);
            if (this.isEmbeddedType(mappedProperty, classMetadata)) {
                Class embeddedType;
                type = embeddedType = this.findPropertyType(mappedProperty, classMetadata);
                classMetadata = this.getManagedType(embeddedType);
                continue;
            }
            attribute = classMetadata.getAttribute(property);
        }
        if (attribute != null) {
            this.accessControl(type, attribute.getName());
        }
        return RSQLJPAContext.of(root, attribute);
    }

    protected Path<?> join(String keyJoin, Path<?> root, String mappedProperty) {
        log.debug("join(keyJoin:{},root:{},mappedProperty:{})", new Object[]{keyJoin, root, mappedProperty});
        if (this.cachedJoins.containsKey(keyJoin)) {
            root = this.cachedJoins.get(keyJoin);
        } else {
            root = ((From)root).join(mappedProperty);
            this.cachedJoins.put(keyJoin, (Path)root);
        }
        return root;
    }

    protected Path<?> joinLeft(String keyJoin, Path<?> root, String mappedProperty) {
        log.debug("joinLeft(keyJoin:{},root:{},mappedProperty:{})", new Object[]{keyJoin, root, mappedProperty});
        if (this.cachedJoins.containsKey(keyJoin)) {
            root = this.cachedJoins.get(keyJoin);
        } else {
            root = ((From)root).join(mappedProperty, JoinType.LEFT);
            this.cachedJoins.put(keyJoin, root);
        }
        return root;
    }

    public Predicate visit(ComparisonNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        ComparisonOperator op = node.getOperator();
        RSQLJPAContext holder = this.findPropertyPath(this.mapPropertyPath(node.getSelector()), (Path)root);
        Path<?> attrPath = holder.getPath();
        if (this.customPredicates.containsKey(op)) {
            RSQLCustomPredicate<?> customPredicate = this.customPredicates.get(op);
            ArrayList<Object> arguments = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                arguments.add(this.convert(argument, customPredicate.getType()));
            }
            return (Predicate)customPredicate.getConverter().apply(RSQLCustomPredicateInput.of((CriteriaBuilder)this.builder, attrPath, arguments, (From)root));
        }
        Attribute<?, ?> attribute = holder.getAttribute();
        Class type = attribute.getJavaType();
        if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
            type = this.getElementCollectionGenericType(type, attribute);
        }
        if (type.isPrimitive()) {
            type = (Class)primitiveToWrapper.get(type);
        } else if (RSQLJPASupport.getValueTypeMap().containsKey(type)) {
            type = (Class)RSQLJPASupport.getValueTypeMap().get(type);
        }
        if (node.getArguments().size() > 1) {
            ArrayList<Object> listObject = new ArrayList<Object>();
            for (String argument : node.getArguments()) {
                listObject.add(this.convert(argument, type));
            }
            if (op.equals((Object)RSQLOperators.IN)) {
                return attrPath.in(listObject);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return attrPath.in(listObject).not();
            }
            if (op.equals((Object)RSQLOperators.BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                return this.builder.between(attrPath, (Comparable)listObject.get(0), (Comparable)listObject.get(1));
            }
            if (op.equals((Object)RSQLOperators.NOT_BETWEEN) && listObject.size() == 2 && listObject.get(0) instanceof Comparable && listObject.get(1) instanceof Comparable) {
                return this.builder.between(attrPath, (Comparable)listObject.get(0), (Comparable)listObject.get(1)).not();
            }
        } else {
            if (op.equals((Object)RSQLOperators.IS_NULL)) {
                return this.builder.isNull(attrPath);
            }
            if (op.equals((Object)RSQLOperators.NOT_NULL)) {
                return this.builder.isNotNull(attrPath);
            }
            Object argument = this.convert((String)node.getArguments().get(0), type);
            if (op.equals((Object)RSQLOperators.IN)) {
                return this.builder.equal(attrPath, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_IN)) {
                return this.builder.notEqual(attrPath, argument);
            }
            if (op.equals((Object)RSQLOperators.LIKE)) {
                return this.builder.like(attrPath, "%" + argument.toString() + "%");
            }
            if (op.equals((Object)RSQLOperators.NOT_LIKE)) {
                return this.builder.like(attrPath, "%" + argument.toString() + "%").not();
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE)) {
                return this.builder.equal(this.builder.upper(attrPath), (Object)argument.toString().toUpperCase());
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_LIKE)) {
                return this.builder.like(this.builder.upper(attrPath), "%" + argument.toString().toUpperCase() + "%");
            }
            if (op.equals((Object)RSQLOperators.IGNORE_CASE_NOT_LIKE)) {
                return this.builder.like(this.builder.upper(attrPath), "%" + argument.toString().toUpperCase() + "%").not();
            }
            if (op.equals((Object)RSQLOperators.EQUAL)) {
                if (type.equals(String.class)) {
                    if (argument.toString().contains("*") && argument.toString().contains("^")) {
                        return this.builder.like(this.builder.upper(attrPath), argument.toString().replace("*", "%").replace("^", "").toUpperCase());
                    }
                    if (argument.toString().contains("*")) {
                        return this.builder.like(attrPath, argument.toString().replace('*', '%'));
                    }
                    if (argument.toString().contains("^")) {
                        return this.builder.equal(this.builder.upper(attrPath), (Object)argument.toString().replace("^", "").toUpperCase());
                    }
                    return this.builder.equal(attrPath, argument);
                }
                if (argument == null) {
                    return this.builder.isNull(attrPath);
                }
                return this.builder.equal(attrPath, argument);
            }
            if (op.equals((Object)RSQLOperators.NOT_EQUAL)) {
                if (type.equals(String.class)) {
                    if (argument.toString().contains("*") && argument.toString().contains("^")) {
                        return this.builder.notLike(this.builder.upper(attrPath), argument.toString().replace("*", "%").replace("^", "").toUpperCase());
                    }
                    if (argument.toString().contains("*")) {
                        return this.builder.notLike(attrPath, argument.toString().replace('*', '%'));
                    }
                    if (argument.toString().contains("^")) {
                        return this.builder.notEqual(this.builder.upper(attrPath), (Object)argument.toString().replace("^", "").toUpperCase());
                    }
                    return this.builder.notEqual(attrPath, argument);
                }
                if (argument == null) {
                    return this.builder.isNotNull(attrPath);
                }
                return this.builder.notEqual(attrPath, argument);
            }
            if (!Comparable.class.isAssignableFrom(type)) {
                log.error("Operator {} can be used only for Comparables", (Object)op);
                throw new IllegalArgumentException(String.format("Operator %s can be used only for Comparables", op));
            }
            Comparable comparable = (Comparable)argument;
            if (op.equals((Object)RSQLOperators.GREATER_THAN)) {
                return this.builder.greaterThan(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.GREATER_THAN_OR_EQUAL)) {
                return this.builder.greaterThanOrEqualTo(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN)) {
                return this.builder.lessThan(attrPath, comparable);
            }
            if (op.equals((Object)RSQLOperators.LESS_THAN_OR_EQUAL)) {
                return this.builder.lessThanOrEqualTo(attrPath, comparable);
            }
        }
        log.error("Unknown operator: {}", (Object)op);
        throw new IllegalArgumentException("Unknown operator: " + op);
    }

    public Predicate visit(AndNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return (Predicate)node.getChildren().stream().map(n -> (Predicate)n.accept((RSQLVisitor)this, (Object)root)).collect(Collectors.reducing((arg_0, arg_1) -> ((CriteriaBuilder)this.builder).and(arg_0, arg_1))).get();
    }

    public Predicate visit(OrNode node, From root) {
        log.debug("visit(node:{},root:{})", (Object)node, (Object)root);
        return (Predicate)node.getChildren().stream().map(n -> (Predicate)n.accept((RSQLVisitor)this, (Object)root)).collect(Collectors.reducing((arg_0, arg_1) -> ((CriteriaBuilder)this.builder).or(arg_0, arg_1))).get();
    }

    public Map<String, String> getPropertyPathMapper() {
        return this.propertyPathMapper;
    }

    public Map<ComparisonOperator, RSQLCustomPredicate<?>> getCustomPredicates() {
        return this.customPredicates;
    }
}

