/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.RSQLCommonSupport;
import io.github.perplexhub.rsql.RSQLCustomPredicate;
import io.github.perplexhub.rsql.RSQLJPAPredicateConverter;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.SortUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class RSQLJPASupport
extends RSQLCommonSupport {
    private static final Logger log = LoggerFactory.getLogger(RSQLJPASupport.class);

    public RSQLJPASupport() {
    }

    public RSQLJPASupport(Map<String, EntityManager> entityManagerMap) {
        super(entityManagerMap);
    }

    public static <T> Specification<T> rsql(String rsqlQuery) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, null);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, boolean distinct) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, null);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, propertyPathMapper);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, boolean distinct, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, propertyPathMapper);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, List<RSQLCustomPredicate<?>> customPredicates) {
        return RSQLJPASupport.toSpecification(rsqlQuery, customPredicates);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, propertyPathMapper);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, boolean distinct) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, boolean distinct, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, propertyPathMapper, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, List<RSQLCustomPredicate<?>> customPredicates) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, null, customPredicates);
    }

    public static <T> Specification<T> toSpecification(final String rsqlQuery, final boolean distinct, final Map<String, String> propertyPathMapper, final List<RSQLCustomPredicate<?>> customPredicates) {
        log.debug("toSpecification({},distinct:{},propertyPathMapper:{})", new Object[]{rsqlQuery, distinct, propertyPathMapper});
        return new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                query.distinct(distinct);
                if (StringUtils.hasText((String)rsqlQuery)) {
                    Set supportedOperators = RSQLOperators.supportedOperators();
                    if (customPredicates != null) {
                        supportedOperators.addAll(customPredicates.stream().map(RSQLCustomPredicate::getOperator).filter(Objects::nonNull).collect(Collectors.toSet()));
                    }
                    Node rsql = new RSQLParser(supportedOperators).parse(rsqlQuery);
                    return (Predicate)rsql.accept((RSQLVisitor)new RSQLJPAPredicateConverter(cb, propertyPathMapper, customPredicates), root);
                }
                return null;
            }
        };
    }

    public static <T> Specification<T> toSort(@Nullable String sortQuery) {
        return RSQLJPASupport.toSort(sortQuery, new HashMap<String, String>());
    }

    public static <T> Specification<T> toSort(final @Nullable String sortQuery, final Map<String, String> propertyPathMapper) {
        log.debug("toSort({},propertyPathMapper:{})", (Object)sortQuery, propertyPathMapper);
        return new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                if (StringUtils.hasText((String)sortQuery)) {
                    List<Order> orders = SortUtils.parseSort(sortQuery, propertyPathMapper, root, cb);
                    query.orderBy(orders);
                    return cb.conjunction();
                }
                return null;
            }
        };
    }

    public static Optional<?> findOne(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery) {
        return jpaSpecificationExecutor.findOne(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    public static List<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery) {
        return jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    public static Page<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery, Pageable pageable) {
        return jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery), pageable);
    }

    public static List<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery, Sort sort) {
        return jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery), sort);
    }

    public static List<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery, @Nullable String sort) {
        return StringUtils.hasText((String)sort) ? jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery), Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])StringUtils.commaDelimitedListToStringArray((String)sort))) : jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    public static long count(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery) {
        return jpaSpecificationExecutor.count(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    protected String getVersion() {
        try {
            Properties prop = new Properties();
            prop.load(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/io.github.perplexhub/rsql-jpa/pom.properties"));
            String version = prop.getProperty("version");
            return StringUtils.hasText((String)version) ? "[" + version + "] " : "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

