/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.springframework.lang.Nullable;

class SortUtils {
    private static final String MULTIPLE_SORT_SEPARATOR = ";";
    private static final String SORT_SEPARATOR = ",";
    private static final String PROPERTY_PATH_SEPARATOR = "\\.";

    SortUtils() {
    }

    static List<Order> parseSort(@Nullable String sort, Map<String, String> propertyMapper, Root<?> root, CriteriaBuilder cb) {
        if (sort == null) {
            return new ArrayList<Order>();
        }
        return Arrays.stream(sort.split(MULTIPLE_SORT_SEPARATOR)).map(item -> item.split(SORT_SEPARATOR)).map(parts -> SortUtils.sortToJpaOrder(parts, propertyMapper, root, cb)).collect(Collectors.toList());
    }

    private static Order sortToJpaOrder(String[] parts, Map<String, String> propertyMapper, Root<?> root, CriteriaBuilder cb) {
        String property = parts[0];
        String direction = parts[1];
        String propertyPath = propertyMapper.getOrDefault(property, property);
        Expression<?> propertyExpression = SortUtils.pathToExpression(root, propertyPath);
        return direction.equalsIgnoreCase("asc") ? cb.asc(propertyExpression) : cb.desc(propertyExpression);
    }

    private static Expression<?> pathToExpression(Root<?> root, String path) {
        String[] properties = path.split(PROPERTY_PATH_SEPARATOR);
        Path expression = root.get(properties[0]);
        for (int i = 1; i < properties.length; ++i) {
            expression = expression.get(properties[i]);
        }
        return expression;
    }
}

