/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql.jsonb;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import io.github.perplexhub.rsql.ResolvedExpression;
import io.github.perplexhub.rsql.jsonb.JsonbExpressionBuilder;
import jakarta.persistence.Column;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.orm.jpa.vendor.Database;

public class JsonbSupport {
    public static boolean DATE_TIME_SUPPORT = false;
    private static final Set<Database> JSON_SUPPORT = EnumSet.of(Database.POSTGRESQL);
    private static final Map<ComparisonOperator, ComparisonOperator> NEGATE_OPERATORS = Map.of(RSQLOperators.NOT_EQUAL, RSQLOperators.EQUAL, RSQLOperators.NOT_IN, RSQLOperators.IN, RSQLOperators.IS_NULL, RSQLOperators.NOT_NULL, RSQLOperators.NOT_LIKE, RSQLOperators.LIKE, RSQLOperators.IGNORE_CASE_NOT_LIKE, RSQLOperators.IGNORE_CASE_LIKE, RSQLOperators.NOT_BETWEEN, RSQLOperators.BETWEEN);

    public static String jsonPathOfSelector(Attribute<?, ?> attrPath, String selector) {
        String attributeName = attrPath.getName();
        int attributePosition = selector.indexOf(attributeName);
        if (attributePosition < 0) {
            throw new IllegalArgumentException("The attribute name [" + attributeName + "] is not part of the selector [" + selector + "]");
        }
        return selector.substring(attributePosition + attributeName.length());
    }

    public static ResolvedExpression jsonbPathExistsExpression(CriteriaBuilder builder, ComparisonNode node, Path<?> attrPath) {
        Optional<ComparisonOperator> mayBeInvertedOperator = Optional.ofNullable(NEGATE_OPERATORS.get(node.getOperator()));
        JsonbExpressionBuilder jsb = new JsonbExpressionBuilder(mayBeInvertedOperator.orElse(node.getOperator()), node.getSelector(), node.getArguments());
        JsonbPathExpression expression = jsb.getJsonPathExpression();
        return ResolvedExpression.ofJson((Expression<Boolean>)builder.function(expression.jsonbFunction, Boolean.class, new Expression[]{attrPath, builder.literal((Object)expression.jsonbPath)}), mayBeInvertedOperator.isPresent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isJsonType(Attribute<?, ?> attribute) {
        if (attribute == null) return false;
        if (!JsonbSupport.isJsonColumn(attribute)) return false;
        if (JsonbSupport.getDatabase(attribute).map(JSON_SUPPORT::contains).orElse(false) == false) return false;
        return true;
    }

    public static boolean isJsonType(String mappedProperty, ManagedType<?> classMetadata) {
        return Optional.ofNullable(RSQLVisitorBase.getAttribute((String)mappedProperty, classMetadata)).map(JsonbSupport::isJsonType).orElse(false);
    }

    private static boolean isJsonColumn(Attribute<?, ?> attribute) {
        return Optional.ofNullable(attribute).filter(attr -> attr.getJavaMember() instanceof Field).map(attr -> (Field)attr.getJavaMember()).map(field -> field.getAnnotation(Column.class)).map(Column::columnDefinition).map("jsonb"::equalsIgnoreCase).orElse(false);
    }

    private static Optional<Database> getDatabase(Attribute<?, ?> attribute) {
        return RSQLVisitorBase.getEntityManagerMap().values().stream().filter(em -> em.getMetamodel().getManagedTypes().contains(attribute.getDeclaringType())).findFirst().map(RSQLVisitorBase::getDatabase);
    }

    record JsonbPathExpression(String jsonbFunction, String jsonbPath) {
    }
}

