/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import io.github.perplexhub.rsql.QuerySupport;
import io.github.perplexhub.rsql.RSQLCommonSupport;
import io.github.perplexhub.rsql.RSQLCustomPredicate;
import io.github.perplexhub.rsql.RSQLJPAPredicateConverter;
import io.github.perplexhub.rsql.RSQLOperators;
import io.github.perplexhub.rsql.RSQLVisitorBase;
import io.github.perplexhub.rsql.SortSupport;
import io.github.perplexhub.rsql.SortUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

public class RSQLJPASupport
extends RSQLCommonSupport {
    private static final Logger log = LoggerFactory.getLogger(RSQLJPASupport.class);

    public RSQLJPASupport() {
    }

    public RSQLJPASupport(Map<String, EntityManager> entityManagerMap) {
        this(entityManagerMap, Map.of());
    }

    public RSQLJPASupport(Map<String, EntityManager> entityManagerMap, Map<EntityManager, Database> entityManagerDatabase) {
        super(entityManagerMap);
        RSQLVisitorBase.setEntityManagerDatabase(entityManagerDatabase);
    }

    public static <T> Specification<T> rsql(String rsqlQuery) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, null);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, boolean distinct) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, null);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, propertyPathMapper);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, boolean distinct, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, propertyPathMapper);
    }

    public static <T> Specification<T> rsql(String rsqlQuery, List<RSQLCustomPredicate<?>> customPredicates) {
        return RSQLJPASupport.toSpecification(rsqlQuery, customPredicates);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, null, null, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, propertyPathMapper, null, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, boolean distinct) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, null, null, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, boolean distinct, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, propertyPathMapper, null, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, List<RSQLCustomPredicate<?>> customPredicates) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, null, customPredicates, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, Map<String, String> propertyPathMapper, Map<String, JoinType> joinHints) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, propertyPathMapper, null, joinHints);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, boolean distinct, Map<String, String> propertyPathMapper, Map<String, JoinType> joinHints) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, propertyPathMapper, null, joinHints);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, propertyPathMapper, customPredicates, joinHints);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, boolean distinct, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints) {
        return RSQLJPASupport.toSpecification(rsqlQuery, distinct, propertyPathMapper, customPredicates, joinHints, null, null);
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints, Map<Class<?>, List<String>> propertyWhitelist, Map<Class<?>, List<String>> propertyBlacklist) {
        return RSQLJPASupport.toSpecification(rsqlQuery, false, propertyPathMapper, customPredicates, joinHints, propertyWhitelist, propertyBlacklist);
    }

    public static <T> Specification<T> toSpecification(QuerySupport querySupport) {
        log.debug("toSpecification({})", (Object)querySupport);
        return (Specification & Serializable)(root, query, cb) -> {
            query.distinct(querySupport.isDistinct());
            if (!StringUtils.hasText((String)querySupport.getRsqlQuery())) {
                return null;
            }
            Set supportedOperators = RSQLOperators.supportedOperators();
            if (querySupport.getCustomPredicates() != null) {
                Stream<ComparisonOperator> customOperators = querySupport.getCustomPredicates().stream().map(RSQLCustomPredicate::getOperator).filter(Objects::nonNull);
                supportedOperators = Stream.concat(supportedOperators.stream(), customOperators).collect(Collectors.toSet());
            }
            Node rsql = new RSQLParser(supportedOperators).parse(querySupport.getRsqlQuery());
            RSQLJPAPredicateConverter visitor = new RSQLJPAPredicateConverter(cb, querySupport.getPropertyPathMapper(), querySupport.getCustomPredicates(), querySupport.getJoinHints(), querySupport.getProcedureWhiteList(), querySupport.getProcedureBlackList(), querySupport.isStrictEquality(), querySupport.getLikeEscapeCharacter(), querySupport.getJsonbConfiguration());
            visitor.setPropertyWhitelist(querySupport.getPropertyWhitelist());
            visitor.setPropertyBlacklist(querySupport.getPropertyBlacklist());
            return (Predicate)rsql.accept((RSQLVisitor)visitor, (Object)root);
        };
    }

    public static <T> Specification<T> toSpecification(String rsqlQuery, boolean distinct, Map<String, String> propertyPathMapper, List<RSQLCustomPredicate<?>> customPredicates, Map<String, JoinType> joinHints, Map<Class<?>, List<String>> propertyWhitelist, Map<Class<?>, List<String>> propertyBlacklist) {
        return RSQLJPASupport.toSpecification(QuerySupport.builder().rsqlQuery(rsqlQuery).distinct(distinct).joinHints(joinHints).propertyPathMapper(propertyPathMapper).customPredicates(customPredicates).propertyWhitelist(propertyWhitelist).propertyBlacklist(propertyBlacklist).build());
    }

    public static <T> Specification<T> toSort(@Nullable String sortQuery) {
        return RSQLJPASupport.toSort(sortQuery, Collections.emptyMap());
    }

    public static <T> Specification<T> toSort(@Nullable String sortQuery, Map<String, String> propertyPathMapper) {
        return RSQLJPASupport.toSort(SortSupport.builder().sortQuery(sortQuery).propertyPathMapper(propertyPathMapper).build());
    }

    public static <T> Specification<T> toSort(SortSupport sortSupport) {
        log.debug("toSort({})", (Object)sortSupport);
        return (Specification & Serializable)(root, query, cb) -> {
            if (StringUtils.hasText((String)sortSupport.getSortQuery())) {
                List<Order> orders = SortUtils.parseSort(sortSupport, root, cb);
                query.orderBy(orders);
            }
            return null;
        };
    }

    public static Optional<?> findOne(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery) {
        return jpaSpecificationExecutor.findOne(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    public static List<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery) {
        return jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    public static Page<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery, Pageable pageable) {
        return jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery), pageable);
    }

    public static List<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery, Sort sort) {
        return jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery), sort);
    }

    public static List<?> findAll(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery, @Nullable String sort) {
        return StringUtils.hasText((String)sort) ? jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery), Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])StringUtils.commaDelimitedListToStringArray((String)sort))) : jpaSpecificationExecutor.findAll(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    public static long count(JpaSpecificationExecutor<?> jpaSpecificationExecutor, @Nullable String rsqlQuery) {
        return jpaSpecificationExecutor.count(RSQLJPASupport.toSpecification(rsqlQuery));
    }

    protected String getVersion() {
        try {
            Properties prop = new Properties();
            prop.load(((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/io.github.perplexhub/rsql-jpa/pom.properties"));
            String version = prop.getProperty("version");
            return StringUtils.hasText((String)version) ? "[" + version + "] " : "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

