/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Insets;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a \u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0003\u001a\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0$2\u0006\u0010%\u001a\u00020\u0011H\u0002\u001a\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0003\u001a\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\u001a\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\"\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004\"\u0014\u0010\u0006\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0014\u0010\u0007\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0004\"\u0014\u0010\b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0014\u0010\t\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0004\"\u0014\u0010\n\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0004\"\u0014\u0010\f\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0004\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0010\u001a\u00020\u000e*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0018\u0010\u0014\u001a\u00020\u000e*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0018\u0010\u0018\u001a\u00020\u000e*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\"\u0018\u0010\u001a\u001a\u00020\u000e*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017\"\u0018\u0010\u001c\u001a\u00020\u000e*\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013\u00a8\u00060"}, d2={"BRAND", "", "isGoogle", "", "()Z", "isHuawei", "isNokia", "isOnePlus", "isOppo", "isSamsung", "isSmarTisan", "isVivo", "isXiaomi", "navigationHeightBf", "", "screenHeightBf", "navigationBarHeight", "Landroid/app/Activity;", "getNavigationBarHeight", "(Landroid/app/Activity;)I", "realScreenHeight", "Landroid/content/Context;", "getRealScreenHeight", "(Landroid/content/Context;)I", "screenHeight", "getScreenHeight", "screenWidth", "getScreenWidth", "statusBarHeight", "getStatusBarHeight", "checkNavigationBarShow", "context", "getNavigationBarHeightFromSystem", "screenSize", "realSize", "getNavigationFromAndroid", "Lkotlin/Pair;", "activity", "getRealNavHeight", "huaWeiNavigationEnabled", "isNavBarVendorHide", "nokiaNavigationEnabled", "onePlusNavigationEnabled", "oppoNavigationEnabled", "samsungNavigationEnabled", "smartisanNavigationEnabled", "vivoNavigationEnabled", "xiaomiNavigationEnabled", "floatingx_release"})
@JvmName(name="_FxScreenExt")
public final class _FxScreenExt {
    private static int screenHeightBf;
    private static int navigationHeightBf;
    @NotNull
    private static final String BRAND;

    public static final int getRealScreenHeight(@NotNull Context $this$realScreenHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$realScreenHeight, (String)"<this>");
        Object object = $this$realScreenHeight.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        display.getRealMetrics(dm);
        return dm.heightPixels;
    }

    public static final int getScreenHeight(@NotNull Context $this$screenHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$screenHeight, (String)"<this>");
        Object object = $this$screenHeight.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        display.getMetrics(dm);
        return dm.heightPixels;
    }

    public static final int getScreenWidth(@NotNull Context $this$screenWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$screenWidth, (String)"<this>");
        Object object = $this$screenWidth.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        display.getMetrics(dm);
        return dm.widthPixels;
    }

    public static final int getStatusBarHeight(@NotNull Activity $this$statusBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$statusBarHeight, (String)"<this>");
        try {
            if (Build.VERSION.SDK_INT >= 24 && $this$statusBarHeight.isInMultiWindowMode()) {
                return 0;
            }
            int resourceId = $this$statusBarHeight.getResources().getIdentifier("status_bar_height", "dimen", "android");
            return $this$statusBarHeight.getResources().getDimensionPixelSize(resourceId);
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
    }

    public static final int getNavigationBarHeight(@NotNull Activity $this$navigationBarHeight) {
        int newNavigationBarHeight;
        Intrinsics.checkNotNullParameter((Object)$this$navigationBarHeight, (String)"<this>");
        int newScreenHeight = _FxScreenExt.getScreenHeight((Context)$this$navigationBarHeight);
        if (newScreenHeight == screenHeightBf) {
            return navigationHeightBf;
        }
        screenHeightBf = newScreenHeight;
        if (Build.VERSION.SDK_INT >= 30) {
            navigationHeightBf = _FxScreenExt.getRealNavHeight((Context)$this$navigationBarHeight);
            return navigationHeightBf;
        }
        Pair<Integer, Integer> pair = _FxScreenExt.getNavigationFromAndroid($this$navigationBarHeight);
        int showFromAndroidStates = ((Number)pair.component1()).intValue();
        int height = ((Number)pair.component2()).intValue();
        switch (showFromAndroidStates) {
            case 1: {
                navigationHeightBf = height;
                return navigationHeightBf;
            }
            case 0: {
                return 0;
            }
        }
        boolean isShow = _FxScreenExt.checkNavigationBarShow((Context)$this$navigationBarHeight) || _FxScreenExt.isNavBarVendorHide((Context)$this$navigationBarHeight) == 0;
        int realSize = _FxScreenExt.getRealScreenHeight((Context)$this$navigationBarHeight);
        navigationHeightBf = newNavigationBarHeight = !isShow || realSize == newScreenHeight ? 0 : _FxScreenExt.getNavigationBarHeightFromSystem(newScreenHeight, realSize, (Context)$this$navigationBarHeight);
        return newNavigationBarHeight;
    }

    private static final Pair<Integer, Integer> getNavigationFromAndroid(Activity activity) {
        try {
            ViewGroup viewGroup;
            View view = activity.getWindow().getDecorView();
            ViewGroup viewGroup2 = viewGroup = view instanceof ViewGroup ? (ViewGroup)view : null;
            if (viewGroup == null) {
                return TuplesKt.to((Object)-1, (Object)0);
            }
            ViewGroup vp = viewGroup;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)vp.getChildCount());
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Integer id;
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                View view2 = vp.getChildAt(i);
                Integer n = id = view2 == null ? null : Integer.valueOf(view2.getId());
                int n2 = 16908336;
                if (n == null || n != n2) continue;
                return TuplesKt.to((Object)1, (Object)vp.findViewById(id.intValue()).getHeight());
            }
        }
        catch (Exception e) {
            return TuplesKt.to((Object)-1, (Object)0);
        }
        return TuplesKt.to((Object)0, (Object)0);
    }

    private static final boolean isXiaomi() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        return Intrinsics.areEqual((Object)string3, (Object)"xiaomi");
    }

    private static final boolean isVivo() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"vivo", (boolean)false, (int)2, null);
    }

    private static final boolean isOppo() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"oppo", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"realme", (boolean)false, (int)2, null);
    }

    private static final boolean isHuawei() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"huawei", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"honor", (boolean)false, (int)2, null);
    }

    private static final boolean isOnePlus() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"oneplus", (boolean)false, (int)2, null);
    }

    private static final boolean isSamsung() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"samsung", (boolean)false, (int)2, null);
    }

    private static final boolean isSmarTisan() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"smartisan", (boolean)false, (int)2, null);
    }

    private static final boolean isNokia() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"nokia", (boolean)false, (int)2, null);
    }

    private static final boolean isGoogle() {
        return StringsKt.contains$default((CharSequence)BRAND, (CharSequence)"google", (boolean)false, (int)2, null);
    }

    @SuppressLint(value={"NewApi"})
    private static final int getRealNavHeight(Context context) {
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        WindowMetrics windowMetrics = wm.getCurrentWindowMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"wm.currentWindowMetrics");
        WindowMetrics windowMetrics2 = windowMetrics;
        WindowInsets windowInsets = windowMetrics2.getWindowInsets();
        Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"windowMetrics.windowInsets");
        WindowInsets windowInsets2 = windowInsets;
        windowInsets2.getInsets(WindowInsets.Type.navigationBars());
        int typeMask = WindowInsets.Type.navigationBars() | WindowInsets.Type.displayCutout();
        Insets insets = windowInsets2.getInsetsIgnoringVisibility(typeMask);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"windowInsets.getInsetsIgnoringVisibility(typeMask)");
        Insets insets2 = insets;
        return insets2.bottom;
    }

    private static final boolean checkNavigationBarShow(Context context) {
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id > 0) {
            hasNavigationBar = rs.getBoolean(id);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[]{String.class};
            Method m = systemPropertiesClass.getMethod("get", classArray);
            Object[] objectArray = new Object[]{"qemu.hw.mainkeys"};
            Object object = m.invoke(systemPropertiesClass, objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String navBarOverride = (String)object;
            int navigationBarIsMin = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0);
            if (Intrinsics.areEqual((Object)"1", (Object)navBarOverride) || 1 == navigationBarIsMin) {
                hasNavigationBar = false;
            } else if (Intrinsics.areEqual((Object)"0", (Object)navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasNavigationBar;
    }

    @SuppressLint(value={"InternalInsetResource"})
    private static final int getNavigationBarHeightFromSystem(int screenSize, int realSize, Context context) {
        int height;
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        return resourceId > 0 ? (realSize - screenSize > (height = context.getResources().getDimensionPixelSize(resourceId)) - 10 ? height : 0) : 0;
    }

    private static final int isNavBarVendorHide(Context context) {
        if (_FxScreenExt.isVivo()) {
            return _FxScreenExt.vivoNavigationEnabled(context);
        }
        if (_FxScreenExt.isOppo()) {
            return _FxScreenExt.oppoNavigationEnabled(context);
        }
        if (_FxScreenExt.isXiaomi()) {
            return _FxScreenExt.xiaomiNavigationEnabled(context);
        }
        if (_FxScreenExt.isHuawei()) {
            return _FxScreenExt.huaWeiNavigationEnabled(context);
        }
        if (_FxScreenExt.isOnePlus()) {
            return _FxScreenExt.onePlusNavigationEnabled(context);
        }
        if (_FxScreenExt.isSamsung()) {
            return _FxScreenExt.samsungNavigationEnabled(context);
        }
        if (_FxScreenExt.isSmarTisan()) {
            return _FxScreenExt.smartisanNavigationEnabled(context);
        }
        if (_FxScreenExt.isNokia()) {
            return _FxScreenExt.nokiaNavigationEnabled(context);
        }
        return _FxScreenExt.isGoogle() ? 0 : -1;
    }

    private static final int vivoNavigationEnabled(Context context) {
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"navigation_gesture_on", (int)0);
    }

    private static final int oppoNavigationEnabled(Context context) {
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"hide_navigationbar_enable", (int)0);
    }

    private static final int xiaomiNavigationEnabled(Context context) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"force_fsg_nav_bar", (int)0);
    }

    private static final int huaWeiNavigationEnabled(Context context) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0);
    }

    private static final int onePlusNavigationEnabled(Context context) {
        int result = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"navigation_mode", (int)0);
        if (result == 2 && Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"buttons_show_on_screen_navkeys", (int)0) != 0) {
            return 0;
        }
        return result;
    }

    private static final int samsungNavigationEnabled(Context context) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_hide_bar_enabled", (int)0);
    }

    private static final int smartisanNavigationEnabled(Context context) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_trigger_mode", (int)0);
    }

    private static final int nokiaNavigationEnabled(Context context) {
        boolean result = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"swipe_up_to_switch_apps_enabled", (int)0) != 0 || Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"navigation_bar_can_hiden", (int)0) != 0;
        return result ? 1 : 0;
    }

    static {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        BRAND = string3;
    }
}

