/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.view;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.petterp.floatingx.assist.helper.FxBasisHelper;
import com.petterp.floatingx.listener.IFxViewLifecycle;
import com.petterp.floatingx.util._FxExt;
import com.petterp.floatingx.view.FxViewHolder;
import com.petterp.floatingx.view.IFxInternalHelper;
import com.petterp.floatingx.view.helper.FxViewAnimationHelper;
import com.petterp.floatingx.view.helper.FxViewBasicHelper;
import com.petterp.floatingx.view.helper.FxViewLocationHelper;
import com.petterp.floatingx.view.helper.FxViewTouchHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010$\u001a\u00020%H&J\b\u0010&\u001a\u00020%H&J\n\u0010'\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u000bH\u0004J \u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%H\u0002J\b\u00100\u001a\u00020*H\u0016J \u00101\u001a\u00020*2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%2\u0006\u0010-\u001a\u00020\u001cH\u0016J \u00104\u001a\u00020*2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%2\u0006\u0010-\u001a\u00020\u001cH\u0016J\b\u00105\u001a\u00020*H\u0016J \u00106\u001a\u00020*2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%2\u0006\u0010-\u001a\u00020\u001cH\u0002J\b\u00107\u001a\u00020*H\u0014J\u0012\u00108\u001a\u00020*2\b\u00109\u001a\u0004\u0018\u00010:H\u0014J\b\u0010;\u001a\u00020*H\u0014J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>H\u0016J0\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u00020B2\u0006\u0010E\u001a\u00020BH\u0014J(\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020B2\u0006\u0010H\u001a\u00020B2\u0006\u0010I\u001a\u00020B2\u0006\u0010J\u001a\u00020BH\u0014J\u0010\u0010K\u001a\u00020*2\u0006\u0010=\u001a\u00020>H&J\u0010\u0010L\u001a\u00020*2\u0006\u0010=\u001a\u00020>H&J\u0010\u0010M\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010N\u001a\u00020*2\u0006\u0010=\u001a\u00020>H&J\u0010\u0010O\u001a\u00020*2\u0006\u0010P\u001a\u00020BH\u0014J\u0016\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020B\u0018\u00010RH&J\u0010\u0010S\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>H\u0016J\u0018\u0010T\u001a\u00020*2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%H\u0004J\u0010\u0010U\u001a\u00020*2\u0006\u0010V\u001a\u00020\u000bH\u0016J\u0010\u0010U\u001a\u00020*2\u0006\u0010W\u001a\u00020BH\u0016J\u0018\u0010X\u001a\u00020*2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%H&R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006Y"}, d2={"Lcom/petterp/floatingx/view/FxBasicContainerView;", "Landroid/widget/FrameLayout;", "Lcom/petterp/floatingx/view/IFxInternalHelper;", "helper", "Lcom/petterp/floatingx/assist/helper/FxBasisHelper;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Lcom/petterp/floatingx/assist/helper/FxBasisHelper;Landroid/content/Context;Landroid/util/AttributeSet;)V", "_childView", "Landroid/view/View;", "_viewHolder", "Lcom/petterp/floatingx/view/FxViewHolder;", "animateHelper", "Lcom/petterp/floatingx/view/helper/FxViewAnimationHelper;", "childView", "getChildView", "()Landroid/view/View;", "containerView", "getContainerView", "()Landroid/widget/FrameLayout;", "getHelper", "()Lcom/petterp/floatingx/assist/helper/FxBasisHelper;", "helpers", "", "Lcom/petterp/floatingx/view/helper/FxViewBasicHelper;", "isInitLayout", "", "locationHelper", "Lcom/petterp/floatingx/view/helper/FxViewLocationHelper;", "touchHelper", "Lcom/petterp/floatingx/view/helper/FxViewTouchHelper;", "viewHolder", "getViewHolder", "()Lcom/petterp/floatingx/view/FxViewHolder;", "currentX", "", "currentY", "inflateLayoutId", "inflateLayoutView", "initView", "", "installChildView", "internalMoveToXY", "useAnimation", "endX", "endY", "invokeClick", "moveLocation", "x", "y", "moveLocationByVector", "moveToEdge", "moveToXY", "onAttachedToWindow", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onDetachedFromWindow", "onInterceptTouchEvent", "event", "Landroid/view/MotionEvent;", "onLayout", "changed", "left", "", "top", "right", "bottom", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchCancel", "onTouchDown", "onTouchEvent", "onTouchMove", "onWindowVisibilityChanged", "visibility", "parentSize", "Lkotlin/Pair;", "preCheckPointerDownTouch", "safeUpdateXY", "updateView", "layoutView", "layoutId", "updateXY", "floatingx_release"})
public abstract class FxBasicContainerView
extends FrameLayout
implements IFxInternalHelper {
    @NotNull
    private final FxBasisHelper helper;
    private boolean isInitLayout;
    @Nullable
    private View _childView;
    @Nullable
    private FxViewHolder _viewHolder;
    @NotNull
    private final FxViewTouchHelper touchHelper;
    @NotNull
    private final FxViewAnimationHelper animateHelper;
    @NotNull
    private final FxViewLocationHelper locationHelper;
    @NotNull
    private final List<FxViewBasicHelper> helpers;

    @JvmOverloads
    public FxBasicContainerView(@NotNull FxBasisHelper helper, @NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.helper = helper;
        this.isInitLayout = true;
        this.touchHelper = new FxViewTouchHelper();
        this.animateHelper = new FxViewAnimationHelper();
        this.locationHelper = new FxViewLocationHelper();
        Object[] objectArray = new FxViewBasicHelper[]{this.locationHelper, this.touchHelper, this.animateHelper};
        this.helpers = CollectionsKt.listOf((Object[])objectArray);
    }

    public /* synthetic */ FxBasicContainerView(FxBasisHelper fxBasisHelper, Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            attributeSet = null;
        }
        this(fxBasisHelper, context, attributeSet);
    }

    @NotNull
    public FxBasisHelper getHelper() {
        return this.helper;
    }

    public abstract float currentX();

    public abstract float currentY();

    public abstract void updateXY(float var1, float var2);

    @Nullable
    public abstract Pair<Integer, Integer> parentSize();

    public abstract void onTouchDown(@NotNull MotionEvent var1);

    public abstract void onTouchMove(@NotNull MotionEvent var1);

    public abstract void onTouchCancel(@NotNull MotionEvent var1);

    public boolean preCheckPointerDownTouch(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return true;
    }

    @Override
    @Nullable
    public View getChildView() {
        return this._childView;
    }

    @Override
    @NotNull
    public FrameLayout getContainerView() {
        return this;
    }

    @Override
    @Nullable
    public FxViewHolder getViewHolder() {
        return this._viewHolder;
    }

    public void initView() {
        Iterable $this$forEach$iv = this.helpers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FxViewBasicHelper it = (FxViewBasicHelper)element$iv;
            boolean bl = false;
            it.initConfig(this);
        }
        this.setVisibility(4);
    }

    @Override
    public void moveToEdge() {
        Pair<Float, Float> pair = this.locationHelper.getDefaultEdgeXY();
        if (pair == null) {
            return;
        }
        Pair<Float, Float> pair2 = pair;
        float x = ((Number)pair2.component1()).floatValue();
        float y = ((Number)pair2.component2()).floatValue();
        this.moveLocation(x, y, true);
    }

    @Override
    public void moveLocation(float x, float y, boolean useAnimation) {
        this.moveToXY(x, y, useAnimation);
    }

    @Override
    public void moveLocationByVector(float x, float y, boolean useAnimation) {
        this.moveToXY(x + this.currentX(), y + this.currentY(), useAnimation);
    }

    @Override
    public void updateView(int layoutId) {
        this.getHelper().getFxLog$floatingx_release().d("fxView -> updateView");
        this.locationHelper.needUpdateLocation();
        this.removeView(this._childView);
        this.installChildView();
    }

    @Override
    public void updateView(@NotNull View layoutView) {
        Intrinsics.checkNotNullParameter((Object)layoutView, (String)"layoutView");
        this.getHelper().getFxLog$floatingx_release().d("fxView -> updateView");
        this.locationHelper.needUpdateLocation();
        this.removeView(this._childView);
        this.installChildView();
    }

    @Override
    public void invokeClick() {
        View.OnClickListener onClickListener = this.getHelper().iFxClickListener;
        if (onClickListener != null) {
            onClickListener.onClick((View)this);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Iterable $this$forEach$iv = this.helpers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FxViewBasicHelper it = (FxViewBasicHelper)element$iv;
            boolean bl = false;
            it.onSizeChanged(w, h, oldw, oldh);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.isInitLayout) {
            return;
        }
        this.isInitLayout = false;
        Iterable $this$forEach$iv = this.helpers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FxViewBasicHelper it = (FxViewBasicHelper)element$iv;
            boolean bl = false;
            it.onInit();
        }
        this.setVisibility(0);
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.touchHelper.interceptTouchEvent(event, this) || super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.touchHelper.touchEvent(event, this) || super.onTouchEvent(event);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        IFxViewLifecycle iFxViewLifecycle = this.getHelper().iFxViewLifecycle;
        if (iFxViewLifecycle != null) {
            iFxViewLifecycle.windowsVisibility(visibility);
        }
    }

    protected void onConfigurationChanged(@Nullable Configuration newConfig) {
        Configuration configuration = newConfig;
        if (configuration == null) {
            return;
        }
        super.onConfigurationChanged(configuration);
        Iterable $this$forEach$iv = this.helpers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FxViewBasicHelper it = (FxViewBasicHelper)element$iv;
            boolean bl = false;
            it.onConfigurationChanged(newConfig);
        }
    }

    protected final void safeUpdateXY(float x, float y) {
        float safeX = this.locationHelper.safeX(x, true);
        float safeY = this.locationHelper.safeY(y, true);
        this.updateXY(safeX, safeY);
    }

    @Nullable
    protected final View installChildView() {
        IFxViewLifecycle iFxViewLifecycle;
        View it;
        boolean bl;
        boolean bl2;
        View view;
        Object object = this.inflateLayoutView();
        View view2 = this._childView = object == null ? this.inflateLayoutId() : object;
        if (this._childView != null) {
            this._viewHolder = new FxViewHolder(this._childView);
        }
        if ((object = this._childView) != null) {
            view = object;
            bl2 = false;
            bl = false;
            it = view;
            boolean bl3 = false;
            iFxViewLifecycle = this.getHelper().iFxViewLifecycle;
            if (iFxViewLifecycle != null) {
                iFxViewLifecycle.initView(it);
            }
        }
        object = this._viewHolder;
        if (object != null) {
            view = object;
            bl2 = false;
            bl = false;
            it = view;
            boolean bl4 = false;
            iFxViewLifecycle = this.getHelper().iFxViewLifecycle;
            if (iFxViewLifecycle != null) {
                iFxViewLifecycle.initView((FxViewHolder)it);
            }
        }
        return this._childView;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IFxViewLifecycle iFxViewLifecycle = this.getHelper().iFxViewLifecycle;
        if (iFxViewLifecycle != null) {
            iFxViewLifecycle.attach();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        IFxViewLifecycle iFxViewLifecycle = this.getHelper().iFxViewLifecycle;
        if (iFxViewLifecycle != null) {
            iFxViewLifecycle.detached();
        }
    }

    private final View inflateLayoutView() {
        View view = this.getHelper().layoutView;
        if (view == null) {
            return null;
        }
        View view2 = view;
        this.getHelper().getFxLog$floatingx_release().d("fxView -> init, way:[layoutView]");
        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
        ViewGroup.LayoutParams lp = layoutParams == null ? (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2) : layoutParams;
        _FxExt.safeAddView((ViewGroup)this, view2, lp);
        return view2;
    }

    private final View inflateLayoutId() {
        if (this.getHelper().layoutId == 0) {
            return null;
        }
        this.getHelper().getFxLog$floatingx_release().d("fxView -> init, way:[layoutId]");
        View view = LayoutInflater.from((Context)this.getContext()).inflate(this.getHelper().layoutId, (ViewGroup)this, false);
        _FxExt.safeAddView$default((ViewGroup)this, view, null, 2, null);
        return view;
    }

    private final void moveToXY(float x, float y, boolean useAnimation) {
        float endX = FxViewLocationHelper.safeX$default(this.locationHelper, x, false, 2, null);
        float endY = FxViewLocationHelper.safeY$default(this.locationHelper, y, false, 2, null);
        this.internalMoveToXY(useAnimation, endX, endY);
        this.locationHelper.checkOrSaveLocation(endX, endY);
        this.getHelper().getFxLog$floatingx_release().d("fxView -> moveToXY: start(" + this.currentX() + ',' + this.currentY() + "),end(" + endX + ',' + endY + ')');
    }

    private final void internalMoveToXY(boolean useAnimation, float endX, float endY) {
        if (useAnimation) {
            this.animateHelper.start(endX, endY);
        } else {
            this.updateXY(endX, endY);
        }
    }

    @JvmOverloads
    public FxBasicContainerView(@NotNull FxBasisHelper helper, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(helper, context, null, 4, null);
    }
}

