/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.view.helper;

import android.content.res.Configuration;
import android.view.View;
import com.petterp.floatingx.assist.FxAdsorbDirection;
import com.petterp.floatingx.assist.FxBoundaryConfig;
import com.petterp.floatingx.assist.FxGravity;
import com.petterp.floatingx.assist.helper.FxBasisHelper;
import com.petterp.floatingx.listener.IFxConfigStorage;
import com.petterp.floatingx.util._FxExt;
import com.petterp.floatingx.view.FxBasicContainerView;
import com.petterp.floatingx.view.helper.FxViewBasicHelper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rJ$\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u001bJ4\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001bH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0006\u0010\t\u001a\u00020\u001fJ\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u001fH\u0016JR\u00100\u001a\u00020\u001f2\b\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000bH\u0016J(\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u000bH\u0016J\u0018\u0010@\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010A\u001a\u00020\bJ\u0018\u0010B\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\b\b\u0002\u0010A\u001a\u00020\bJ\b\u0010C\u001a\u00020\u001fH\u0002J\b\u0010D\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R0\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001b*\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006E"}, d2={"Lcom/petterp/floatingx/view/helper/FxViewLocationHelper;", "Lcom/petterp/floatingx/view/helper/FxViewBasicHelper;", "Landroid/view/View$OnLayoutChangeListener;", "()V", "moveBoundary", "Lcom/petterp/floatingx/assist/FxBoundaryConfig;", "moveIngBoundary", "needUpdateConfig", "", "needUpdateLocation", "orientation", "", "parentH", "", "parentW", "restoreLeftStandard", "restoreTopStandard", "screenHeightDp", "screenWidthDp", "viewH", "viewW", "x", "getX", "()F", "y", "getY", "safeLocationXY", "Lkotlin/Pair;", "getSafeLocationXY", "(Lkotlin/Pair;)Lkotlin/Pair;", "checkOrRestoreLocation", "", "checkOrSaveLocation", "getAdsorbDirectionLocation", "isNearestLeft", "isNearestTop", "getDefaultEdgeXY", "getDefaultXY", "width", "height", "getHistoryXY", "initConfig", "parentView", "Lcom/petterp/floatingx/view/FxBasicContainerView;", "onConfigurationChanged", "config", "Landroid/content/res/Configuration;", "onInit", "onLayoutChange", "v", "Landroid/view/View;", "left", "top", "right", "bottom", "oldLeft", "oldTop", "oldRight", "oldBottom", "onSizeChanged", "w", "h", "oldW", "oldH", "safeX", "isMoveIng", "safeY", "updateBoundary", "updateViewSize", "floatingx_release"})
public final class FxViewLocationHelper
extends FxViewBasicHelper
implements View.OnLayoutChangeListener {
    private float parentW;
    private float parentH;
    private float viewW;
    private float viewH;
    private int screenWidthDp;
    private int screenHeightDp;
    private boolean restoreLeftStandard;
    private boolean restoreTopStandard;
    private boolean needUpdateLocation;
    private boolean needUpdateConfig;
    private int orientation = 1;
    @NotNull
    private final FxBoundaryConfig moveIngBoundary = new FxBoundaryConfig(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    @NotNull
    private final FxBoundaryConfig moveBoundary = new FxBoundaryConfig(0.0f, 0.0f, 0.0f, 0.0f, 15, null);

    private final float getX() {
        float f;
        FxBasicContainerView fxBasicContainerView = this.getBasicView();
        return fxBasicContainerView == null ? 0.0f : (f = fxBasicContainerView.currentX());
    }

    private final float getY() {
        float f;
        FxBasicContainerView fxBasicContainerView = this.getBasicView();
        return fxBasicContainerView == null ? 0.0f : (f = fxBasicContainerView.currentY());
    }

    @Override
    public void initConfig(@NotNull FxBasicContainerView parentView) {
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        super.initConfig(parentView);
        parentView.addOnLayoutChangeListener(this);
        Configuration configuration = parentView.getResources().getConfiguration();
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$initConfig_u24lambda_u2d0 = configuration;
        boolean bl3 = false;
        this.orientation = $this$initConfig_u24lambda_u2d0.orientation;
        this.screenWidthDp = $this$initConfig_u24lambda_u2d0.screenWidthDp;
        this.screenHeightDp = $this$initConfig_u24lambda_u2d0.screenHeightDp;
    }

    @Override
    public void onInit() {
        Pair<Float, Float> pair;
        IFxConfigStorage iFxConfigStorage;
        boolean hasHistory = this.getConfig().enableSaveDirection && ((iFxConfigStorage = this.getConfig().iFxConfigStorage) == null ? false : iFxConfigStorage.hasConfig());
        String locationFrom = null;
        if (hasHistory) {
            locationFrom = "history_location";
            pair = this.getHistoryXY();
        } else if (this.getConfig().getHasDefaultXY$floatingx_release()) {
            locationFrom = "user_init_location";
            pair = TuplesKt.to((Object)Float.valueOf(this.getConfig().defaultX), (Object)Float.valueOf(this.getConfig().defaultY));
        } else {
            locationFrom = "default_location";
            pair = this.getDefaultXY(this.parentW, this.parentH, this.viewW, this.viewH);
        }
        Pair<Float, Float> pair2 = pair;
        float defaultX = ((Number)pair2.component1()).floatValue();
        float defaultY = ((Number)pair2.component2()).floatValue();
        FxBasicContainerView fxBasicContainerView = this.getBasicView();
        if (fxBasicContainerView != null) {
            fxBasicContainerView.updateXY(FxViewLocationHelper.safeX$default(this, defaultX, false, 2, null), FxViewLocationHelper.safeY$default(this, defaultY, false, 2, null));
        }
        this.getConfig().getFxLog$floatingx_release().d("fxView -> initLocation: x:" + defaultX + ",y:" + defaultY + ",way:[" + locationFrom + ']');
    }

    @Override
    public void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.updateViewSize();
        this.checkOrRestoreLocation();
    }

    @Override
    public void onConfigurationChanged(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.orientation != this.orientation || config.screenWidthDp != this.screenWidthDp || config.screenHeightDp != this.screenHeightDp) {
            this.orientation = config.orientation;
            this.screenWidthDp = config.screenWidthDp;
            this.screenHeightDp = config.screenHeightDp;
            this.restoreLeftStandard = this.isNearestLeft(this.getX());
            this.restoreTopStandard = this.isNearestTop(this.getY());
            this.needUpdateLocation = true;
            this.needUpdateConfig = true;
            this.getConfig().getFxLog$floatingx_release().d("fxView -> onConfigurationChanged:[screenChanged:" + this.needUpdateLocation + ']');
        }
    }

    public void onLayoutChange(@Nullable View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        this.checkOrRestoreLocation();
    }

    public final void needUpdateLocation() {
        this.needUpdateLocation = true;
    }

    @Nullable
    public final Pair<Float, Float> getDefaultEdgeXY() {
        return this.getConfig().enableEdgeAdsorption ? this.getAdsorbDirectionLocation(this.isNearestLeft(this.getX()), this.isNearestTop(this.getY())) : (this.getConfig().enableEdgeRebound ? TuplesKt.to((Object)Float.valueOf(this.getX()), (Object)Float.valueOf(this.getY())) : (Pair)null);
    }

    public final float safeX(float x, boolean isMoveIng) {
        boolean enableBound = isMoveIng && this.getConfig().enableEdgeRebound;
        float minW = enableBound ? this.moveIngBoundary.getMinW() : this.moveBoundary.getMinW();
        float maxW = enableBound ? this.moveIngBoundary.getMaxW() : this.moveBoundary.getMaxW();
        return _FxExt.coerceInFx(x, minW, maxW);
    }

    public static /* synthetic */ float safeX$default(FxViewLocationHelper fxViewLocationHelper, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fxViewLocationHelper.safeX(f, bl);
    }

    public final float safeY(float y, boolean isMoveIng) {
        boolean enableBound = isMoveIng && this.getConfig().enableEdgeRebound;
        float minH = enableBound ? this.moveIngBoundary.getMinH() : this.moveBoundary.getMinH();
        float maxH = enableBound ? this.moveIngBoundary.getMaxH() : this.moveBoundary.getMaxH();
        return _FxExt.coerceInFx(y, minH, maxH);
    }

    public static /* synthetic */ float safeY$default(FxViewLocationHelper fxViewLocationHelper, float f, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return fxViewLocationHelper.safeY(f, bl);
    }

    public final void checkOrSaveLocation(float x, float y) {
        if (this.getConfig().iFxConfigStorage == null || !this.getConfig().enableSaveDirection) {
            return;
        }
        IFxConfigStorage iFxConfigStorage = this.getConfig().iFxConfigStorage;
        Intrinsics.checkNotNull((Object)iFxConfigStorage);
        iFxConfigStorage.update(x, y);
        this.getConfig().getFxLog$floatingx_release().d("saveLocation -> x:" + x + ",y:" + y);
    }

    private final Pair<Float, Float> getAdsorbDirectionLocation(boolean isNearestLeft, boolean isNearestTop) {
        Pair pair;
        FxAdsorbDirection fxAdsorbDirection = this.getConfig().adsorbDirection;
        int n = WhenMappings.$EnumSwitchMapping$0[fxAdsorbDirection.ordinal()];
        switch (n) {
            case 1: {
                float moveX = this.moveBoundary.getMinW();
                float moveY = FxViewLocationHelper.safeY$default(this, this.getY(), false, 2, null);
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
                break;
            }
            case 2: {
                float moveX = this.moveBoundary.getMaxW();
                float moveY = FxViewLocationHelper.safeY$default(this, this.getY(), false, 2, null);
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
                break;
            }
            case 3: {
                float moveX = isNearestLeft ? this.moveBoundary.getMinW() : this.moveBoundary.getMaxW();
                float moveY = FxViewLocationHelper.safeY$default(this, this.getY(), false, 2, null);
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
                break;
            }
            case 4: {
                float moveX = FxViewLocationHelper.safeX$default(this, this.getX(), false, 2, null);
                float moveY = this.moveBoundary.getMinH();
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
                break;
            }
            case 5: {
                float moveX = FxViewLocationHelper.safeX$default(this, this.getX(), false, 2, null);
                float moveY = this.moveBoundary.getMaxH();
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
                break;
            }
            case 6: {
                float moveX = FxViewLocationHelper.safeX$default(this, this.getX(), false, 2, null);
                float moveY = isNearestTop ? this.moveBoundary.getMinH() : this.moveBoundary.getMaxH();
                pair = TuplesKt.to((Object)Float.valueOf(moveX), (Object)Float.valueOf(moveY));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    private final void updateViewSize() {
        Pair<Integer, Integer> pair = this.getBasicView();
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> view = pair;
        Pair<Integer, Integer> pair2 = view.parentSize();
        if (pair2 == null) {
            return;
        }
        pair = pair2;
        int pW = ((Number)pair.component1()).intValue();
        int pH = ((Number)pair.component2()).intValue();
        float viewH = view.getHeight();
        float viewW = view.getWidth();
        this.parentW = pW;
        this.parentH = pH;
        this.viewW = viewW;
        this.viewH = viewH;
        this.updateBoundary();
        this.getConfig().getFxLog$floatingx_release().d("fxView -> updateSize: parentW:" + this.parentW + ",parentH:" + this.parentH + ",viewW:" + viewW + ",viewH:" + viewH);
    }

    private final boolean isNearestLeft(float x) {
        float viewMiddlePoint = x + this.viewW / (float)2;
        float middle = this.parentW / (float)2;
        return viewMiddlePoint < middle;
    }

    private final boolean isNearestTop(float y) {
        float viewMiddlePoint = y + this.viewH / (float)2;
        float middle = this.parentH / (float)2;
        return viewMiddlePoint < middle;
    }

    private final Pair<Float, Float> getHistoryXY() {
        float f;
        float f2;
        FxBasisHelper fxBasisHelper = this.getConfig();
        boolean bl = false;
        boolean bl2 = false;
        FxBasisHelper $this$getHistoryXY_u24lambda_u2d1 = fxBasisHelper;
        boolean bl3 = false;
        IFxConfigStorage iFxConfigStorage = $this$getHistoryXY_u24lambda_u2d1.iFxConfigStorage;
        float configX = iFxConfigStorage == null ? 0.0f : (f2 = iFxConfigStorage.getX());
        IFxConfigStorage iFxConfigStorage2 = $this$getHistoryXY_u24lambda_u2d1.iFxConfigStorage;
        float configY = iFxConfigStorage2 == null ? 0.0f : (f = iFxConfigStorage2.getY());
        return TuplesKt.to((Object)Float.valueOf(configX), (Object)Float.valueOf(configY));
    }

    private final Pair<Float, Float> getDefaultXY(float width, float height, float viewW, float viewH) {
        Pair pair;
        FxBasisHelper fxBasisHelper = this.getConfig();
        boolean bl = false;
        boolean bl2 = false;
        FxBasisHelper $this$getDefaultXY_u24lambda_u2d2 = fxBasisHelper;
        boolean bl3 = false;
        float l = $this$getDefaultXY_u24lambda_u2d2.fxBorderMargin.getL() + $this$getDefaultXY_u24lambda_u2d2.getSafeEdgeOffSet();
        float r = $this$getDefaultXY_u24lambda_u2d2.fxBorderMargin.getR() + $this$getDefaultXY_u24lambda_u2d2.getSafeEdgeOffSet();
        float b = $this$getDefaultXY_u24lambda_u2d2.fxBorderMargin.getB() + $this$getDefaultXY_u24lambda_u2d2.getSafeEdgeOffSet();
        float t = $this$getDefaultXY_u24lambda_u2d2.fxBorderMargin.getT() + $this$getDefaultXY_u24lambda_u2d2.getSafeEdgeOffSet();
        FxGravity fxGravity = $this$getDefaultXY_u24lambda_u2d2.gravity;
        int n = WhenMappings.$EnumSwitchMapping$1[fxGravity.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                pair = TuplesKt.to((Object)Float.valueOf(l), (Object)Float.valueOf(t));
                break;
            }
            case 3: {
                pair = TuplesKt.to((Object)Float.valueOf(l), (Object)Float.valueOf(_FxExt.shr(height - viewH, 2)));
                break;
            }
            case 4: {
                pair = TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Float.valueOf(height - viewH - b));
                break;
            }
            case 5: {
                pair = TuplesKt.to((Object)Float.valueOf(width - viewW - r), (Object)Float.valueOf(t));
                break;
            }
            case 6: {
                pair = TuplesKt.to((Object)Float.valueOf(width - viewW - r), (Object)Float.valueOf(_FxExt.shr(height - viewH, 2)));
                break;
            }
            case 7: {
                pair = TuplesKt.to((Object)Float.valueOf(width - viewW - r), (Object)Float.valueOf(height - viewH - b));
                break;
            }
            case 8: {
                pair = TuplesKt.to((Object)Float.valueOf(_FxExt.shr(width - viewW, 2)), (Object)Float.valueOf(t));
                break;
            }
            case 9: {
                pair = TuplesKt.to((Object)Float.valueOf(_FxExt.shr(width - viewW, 2)), (Object)Float.valueOf(height - viewH - b));
                break;
            }
            default: {
                pair = TuplesKt.to((Object)Float.valueOf(_FxExt.shr(width - viewW, 2)), (Object)Float.valueOf(_FxExt.shr(height - viewH, 2)));
            }
        }
        return this.getSafeLocationXY((Pair<Float, Float>)pair);
    }

    private final Pair<Float, Float> getSafeLocationXY(Pair<Float, Float> $this$safeLocationXY) {
        float offX = this.getConfig().offsetX;
        float offY = this.getConfig().offsetY;
        return TuplesKt.to((Object)Float.valueOf(((Number)$this$safeLocationXY.getFirst()).floatValue() + offX), (Object)Float.valueOf(((Number)$this$safeLocationXY.getSecond()).floatValue() + offY));
    }

    private final void updateBoundary() {
        FxBasisHelper fxBasisHelper = this.getConfig();
        boolean bl = false;
        boolean bl2 = false;
        FxBasisHelper $this$updateBoundary_u24lambda_u2d5 = fxBasisHelper;
        boolean bl3 = false;
        FxBoundaryConfig fxBoundaryConfig = this.moveIngBoundary;
        boolean bl4 = false;
        boolean bl5 = false;
        FxBoundaryConfig $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d3 = fxBoundaryConfig;
        boolean bl6 = false;
        $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d3.setMinW(0.0f);
        $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d3.setMaxW(this.parentW - this.viewW);
        $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d3.setMinH($this$updateBoundary_u24lambda_u2d5.statsBarHeight);
        $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d3.setMaxH(this.parentH - this.viewH - (float)$this$updateBoundary_u24lambda_u2d5.navigationBarHeight);
        fxBoundaryConfig = this.moveBoundary.copy(this.moveIngBoundary);
        bl4 = false;
        bl5 = false;
        FxBoundaryConfig $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d4 = fxBoundaryConfig;
        boolean bl7 = false;
        FxBoundaryConfig fxBoundaryConfig2 = $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d4;
        fxBoundaryConfig2.setMinW(fxBoundaryConfig2.getMinW() + ($this$updateBoundary_u24lambda_u2d5.fxBorderMargin.getL() + $this$updateBoundary_u24lambda_u2d5.edgeOffset));
        fxBoundaryConfig2 = $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d4;
        fxBoundaryConfig2.setMaxW(fxBoundaryConfig2.getMaxW() - ($this$updateBoundary_u24lambda_u2d5.fxBorderMargin.getR() + $this$updateBoundary_u24lambda_u2d5.edgeOffset));
        fxBoundaryConfig2 = $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d4;
        fxBoundaryConfig2.setMinH(fxBoundaryConfig2.getMinH() + ($this$updateBoundary_u24lambda_u2d5.fxBorderMargin.getT() + $this$updateBoundary_u24lambda_u2d5.edgeOffset));
        fxBoundaryConfig2 = $this$updateBoundary_u24lambda_u2d5_u24lambda_u2d4;
        fxBoundaryConfig2.setMaxH(fxBoundaryConfig2.getMaxH() - ($this$updateBoundary_u24lambda_u2d5.fxBorderMargin.getB() + $this$updateBoundary_u24lambda_u2d5.edgeOffset));
    }

    private final void checkOrRestoreLocation() {
        Pair<Float, Float> pair;
        if (!this.needUpdateLocation) {
            return;
        }
        this.getConfig().getFxLog$floatingx_release().d("fxView -> restoreLocation,start");
        this.updateViewSize();
        if (this.getConfig().enableEdgeAdsorption) {
            Pair pair2 = this.needUpdateConfig ? TuplesKt.to((Object)this.restoreLeftStandard, (Object)this.restoreTopStandard) : TuplesKt.to((Object)this.isNearestLeft(this.getX()), (Object)this.isNearestTop(this.getY()));
            boolean isNearestLeft = (Boolean)pair2.component1();
            boolean isNearestTop = (Boolean)pair2.component2();
            pair = this.getAdsorbDirectionLocation(isNearestLeft, isNearestTop);
        } else {
            pair = TuplesKt.to((Object)Float.valueOf(FxViewLocationHelper.safeX$default(this, this.getX(), false, 2, null)), (Object)Float.valueOf(FxViewLocationHelper.safeY$default(this, this.getY(), false, 2, null)));
        }
        Pair<Float, Float> pair3 = pair;
        float restoreX = ((Number)pair3.component1()).floatValue();
        float restoreY = ((Number)pair3.component2()).floatValue();
        this.restoreLeftStandard = false;
        this.restoreTopStandard = false;
        this.needUpdateLocation = false;
        this.needUpdateConfig = false;
        FxBasicContainerView fxBasicContainerView = this.getBasicView();
        if (fxBasicContainerView != null) {
            fxBasicContainerView.moveLocation(restoreX, restoreY, false);
        }
        this.getConfig().getFxLog$floatingx_release().d("fxView -> restoreLocation,success");
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[FxAdsorbDirection.values().length];
            nArray[FxAdsorbDirection.LEFT.ordinal()] = 1;
            nArray[FxAdsorbDirection.RIGHT.ordinal()] = 2;
            nArray[FxAdsorbDirection.LEFT_OR_RIGHT.ordinal()] = 3;
            nArray[FxAdsorbDirection.TOP.ordinal()] = 4;
            nArray[FxAdsorbDirection.BOTTOM.ordinal()] = 5;
            nArray[FxAdsorbDirection.TOP_OR_BOTTOM.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FxGravity.values().length];
            nArray[FxGravity.DEFAULT.ordinal()] = 1;
            nArray[FxGravity.LEFT_OR_TOP.ordinal()] = 2;
            nArray[FxGravity.LEFT_OR_CENTER.ordinal()] = 3;
            nArray[FxGravity.LEFT_OR_BOTTOM.ordinal()] = 4;
            nArray[FxGravity.RIGHT_OR_TOP.ordinal()] = 5;
            nArray[FxGravity.RIGHT_OR_CENTER.ordinal()] = 6;
            nArray[FxGravity.RIGHT_OR_BOTTOM.ordinal()] = 7;
            nArray[FxGravity.TOP_OR_CENTER.ordinal()] = 8;
            nArray[FxGravity.BOTTOM_OR_CENTER.ordinal()] = 9;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

