/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.view.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.petterp.floatingx.assist.FxDisplayMode;
import com.petterp.floatingx.listener.IFxTouchListener;
import com.petterp.floatingx.util._FxExt;
import com.petterp.floatingx.view.FxBasicContainerView;
import com.petterp.floatingx.view.helper.FxViewBasicHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010 \u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0017J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/petterp/floatingx/view/helper/FxViewTouchHelper;", "Lcom/petterp/floatingx/view/helper/FxViewBasicHelper;", "()V", "initX", "", "initY", "isClickEvent", "", "isEnableClick", "mLastTouchDownTime", "", "scaledTouchSlop", "touchDownId", "", "canInterceptEvent", "event", "Landroid/view/MotionEvent;", "checkClickState", "", "hasMainPointerId", "initClickConfig", "initConfig", "parentView", "Lcom/petterp/floatingx/view/FxBasicContainerView;", "initTouchDown", "interceptTouchEvent", "basicView", "isCurrentPointerId", "ev", "performClickAction", "reset", "touchCancel", "touchEvent", "touchToMove", "touchToPointerDown", "floatingx_release"})
public final class FxViewTouchHelper
extends FxViewBasicHelper {
    private float initX;
    private float initY;
    private float scaledTouchSlop;
    private boolean isClickEvent;
    private boolean isEnableClick = true;
    private long mLastTouchDownTime;
    private int touchDownId = -1;

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public void initConfig(@NotNull FxBasicContainerView parentView) {
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        super.initConfig(parentView);
        this.scaledTouchSlop = ViewConfiguration.get((Context)parentView.getContext()).getScaledTouchSlop();
        this.reset();
    }

    public final boolean touchEvent(@NotNull MotionEvent event, @NotNull FxBasicContainerView basicView) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)basicView, (String)"basicView");
        IFxTouchListener iFxTouchListener = this.getConfig().iFxTouchListener;
        if (iFxTouchListener != null) {
            iFxTouchListener.eventIng(event);
        }
        if (this.getConfig().displayMode != FxDisplayMode.DisplayOnly) {
            int n = event.getActionMasked();
            switch (n) {
                case 0: {
                    this.initTouchDown(event);
                    break;
                }
                case 2: {
                    this.touchToMove(event);
                    break;
                }
                case 5: {
                    this.touchToPointerDown(event);
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    this.touchCancel(event);
                }
            }
        }
        return (iFxTouchListener = this.getConfig().iFxTouchListener) == null ? false : (bl = iFxTouchListener.onTouch(event, basicView));
    }

    public final boolean interceptTouchEvent(@NotNull MotionEvent event, @NotNull FxBasicContainerView basicView) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)basicView, (String)"basicView");
        IFxTouchListener listener = this.getConfig().iFxTouchListener;
        if (this.getConfig().displayMode == FxDisplayMode.DisplayOnly) {
            return false;
        }
        int n = event.getAction();
        switch (n) {
            case 0: {
                if (this.hasMainPointerId()) {
                    return false;
                }
                this.initTouchDown(event);
                break;
            }
            case 2: {
                if (!this.isCurrentPointerId(event)) {
                    return false;
                }
                return this.getConfig().displayMode.getCanMove() && this.canInterceptEvent(event);
            }
            case 1: 
            case 3: {
                if (!this.isCurrentPointerId(event)) {
                    return false;
                }
                this.reset();
                this.getConfig().getFxLog$floatingx_release().d("fxView -> interceptEventCancel");
            }
        }
        IFxTouchListener iFxTouchListener = listener;
        return iFxTouchListener == null ? false : (bl = iFxTouchListener.onInterceptTouchEvent(event, basicView));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canInterceptEvent(MotionEvent event) {
        float f = event.getRawX() - this.initX;
        boolean bl = false;
        if (Math.abs(f) >= this.scaledTouchSlop) return true;
        f = event.getRawY() - this.initY;
        bl = false;
        if (!(Math.abs(f) >= this.scaledTouchSlop)) return false;
        return true;
    }

    private final void initTouchDown(MotionEvent event) {
        if (this.hasMainPointerId()) {
            return;
        }
        this.initClickConfig(event);
        this.touchDownId = _FxExt.getPointerId(event);
        Object object = this.getBasicView();
        if (object != null) {
            ((FxBasicContainerView)object).onTouchDown(event);
        }
        object = this.getConfig().iFxTouchListener;
        if (object != null) {
            object.down();
        }
        this.getConfig().getFxLog$floatingx_release().d(Intrinsics.stringPlus((String)"fxView -> initDownTouch,mainTouchId:", (Object)this.touchDownId));
    }

    private final void initClickConfig(MotionEvent event) {
        this.initX = event.getRawX();
        this.initY = event.getRawY();
        if (!this.getConfig().enableClickListener || this.getConfig().iFxClickListener == null) {
            return;
        }
        this.isClickEvent = true;
        this.mLastTouchDownTime = System.currentTimeMillis();
    }

    private final void touchToPointerDown(MotionEvent event) {
        if (this.hasMainPointerId()) {
            this.getConfig().getFxLog$floatingx_release().d("fxView -> touchToPointerDown: currentId:" + _FxExt.getPointerId(event) + ", mainTouchId:" + this.touchDownId + " exist,return");
            return;
        }
        FxBasicContainerView fxBasicContainerView = this.getBasicView();
        if (!(fxBasicContainerView == null ? false : fxBasicContainerView.preCheckPointerDownTouch(event))) {
            this.getConfig().getFxLog$floatingx_release().d("fxView -> touchToPointerDown: current touch location error,return");
            return;
        }
        this.initTouchDown(event);
    }

    private final void touchToMove(MotionEvent event) {
        float f;
        float f2;
        if (!this.isCurrentPointerId(event)) {
            return;
        }
        this.checkClickState(event);
        if (!this.getConfig().displayMode.getCanMove()) {
            return;
        }
        FxBasicContainerView fxBasicContainerView = this.getBasicView();
        if (fxBasicContainerView != null) {
            fxBasicContainerView.onTouchMove(event);
        }
        FxBasicContainerView fxBasicContainerView2 = this.getBasicView();
        float x = fxBasicContainerView2 == null ? -1.0f : (f2 = fxBasicContainerView2.currentX());
        Object object = this.getBasicView();
        float y = object == null ? -1.0f : (f = ((FxBasicContainerView)object).currentY());
        object = this.getConfig().iFxTouchListener;
        if (object != null) {
            object.dragIng(event, x, y);
        }
        this.getConfig().getFxLog$floatingx_release().v("fxView -> touchMove,x:" + x + ",y:" + y);
    }

    private final void touchCancel(MotionEvent event) {
        Object object;
        if (this.getConfig().enableEdgeAdsorption && this.getConfig().displayMode.getCanMove() && (object = this.getBasicView()) != null) {
            ((FxBasicContainerView)object).moveToEdge();
        }
        if ((object = this.getBasicView()) != null) {
            ((FxBasicContainerView)object).onTouchCancel(event);
        }
        object = this.getConfig().iFxTouchListener;
        if (object != null) {
            object.up();
        }
        this.performClickAction();
        this.getConfig().getFxLog$floatingx_release().d("fxView -> mainTouchUp");
    }

    private final void performClickAction() {
        if (this.isClickEvent && this.getConfig().getHasClickStatus$floatingx_release()) {
            long diffTime = System.currentTimeMillis() - this.mLastTouchDownTime;
            if (diffTime < 150L && this.isEnableClick) {
                Object object;
                if (this.getConfig().clickTime > 0L) {
                    this.isEnableClick = false;
                    object = this.getBasicView();
                    if (object != null) {
                        object.postDelayed(() -> FxViewTouchHelper.performClickAction$lambda-0(this), this.getConfig().clickTime);
                    }
                }
                if ((object = this.getConfig().iFxClickListener) != null) {
                    object.onClick((View)this.getBasicView());
                }
            } else if (diffTime >= 500L) {
                boolean bl;
                boolean isHandle;
                Object object = this.getConfig().iFxLongClickListener;
                boolean bl2 = isHandle = object == null ? false : (bl = object.onLongClick((View)this.getBasicView()));
                if (isHandle && (object = this.getBasicView()) != null) {
                    object.performHapticFeedback(0);
                }
            }
        }
        this.reset();
    }

    /*
     * Unable to fully structure code
     */
    private final void checkClickState(MotionEvent event) {
        if (!this.isClickEvent) {
            return;
        }
        var2_2 = event.getRawX() - this.initX;
        var3_3 = false;
        if (!(Math.abs(var2_2) < this.scaledTouchSlop)) ** GOTO lbl-1000
        var2_2 = event.getRawY() - this.initY;
        var3_3 = false;
        if (Math.abs(var2_2) < this.scaledTouchSlop) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isClickEvent = v0;
    }

    private final boolean isCurrentPointerId(MotionEvent ev) {
        if (this.touchDownId == -1) {
            return false;
        }
        return _FxExt.getPointerId(ev) == this.touchDownId;
    }

    private final void reset() {
        this.initX = 0.0f;
        this.initY = 0.0f;
        this.isClickEvent = false;
        this.mLastTouchDownTime = 0L;
        this.touchDownId = -1;
    }

    private final boolean hasMainPointerId() {
        return this.touchDownId != -1;
    }

    private static final void performClickAction$lambda-0(FxViewTouchHelper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isEnableClick = true;
    }
}

