/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.imp.app;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.petterp.floatingx.assist.helper.FxAppHelper;
import com.petterp.floatingx.imp.app.FxAppControlImp;
import com.petterp.floatingx.imp.app.FxAppLifecycleImp;
import com.petterp.floatingx.listener.provider.IFxPlatformProvider;
import com.petterp.floatingx.util._FxExt;
import com.petterp.floatingx.view.FxDefaultContainerView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020!H\u0002J\n\u0010&\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010'\u001a\u00020$H\u0002J\b\u0010(\u001a\u00020$H\u0002J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010*\u001a\u00020$H\u0002J\b\u0010+\u001a\u00020$H\u0016J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020$H\u0016R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/petterp/floatingx/imp/app/FxAppPlatformProvider;", "Lcom/petterp/floatingx/listener/provider/IFxPlatformProvider;", "Lcom/petterp/floatingx/assist/helper/FxAppHelper;", "helper", "control", "Lcom/petterp/floatingx/imp/app/FxAppControlImp;", "(Lcom/petterp/floatingx/assist/helper/FxAppHelper;Lcom/petterp/floatingx/imp/app/FxAppControlImp;)V", "_containerGroup", "Ljava/lang/ref/WeakReference;", "Landroid/view/ViewGroup;", "_internalView", "Lcom/petterp/floatingx/view/FxDefaultContainerView;", "_lifecycleImp", "Lcom/petterp/floatingx/imp/app/FxAppLifecycleImp;", "containerGroupView", "getContainerGroupView", "()Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "getControl", "()Lcom/petterp/floatingx/imp/app/FxAppControlImp;", "getHelper", "()Lcom/petterp/floatingx/assist/helper/FxAppHelper;", "internalView", "getInternalView", "()Lcom/petterp/floatingx/view/FxDefaultContainerView;", "windowsInsetsListener", "Landroidx/core/view/OnApplyWindowInsetsListener;", "attach", "", "activity", "Landroid/app/Activity;", "checkOrInit", "checkOrInitSafeArea", "", "act", "checkOrReInitGroupView", "checkRegisterAppLifecycle", "clearWindowsInsetsListener", "destroyToDetach", "detach", "hide", "reAttach", "reset", "show", "floatingx_release"})
public final class FxAppPlatformProvider
implements IFxPlatformProvider<FxAppHelper> {
    @NotNull
    private final FxAppHelper helper;
    @NotNull
    private final FxAppControlImp control;
    @Nullable
    private FxAppLifecycleImp _lifecycleImp;
    @Nullable
    private FxDefaultContainerView _internalView;
    @Nullable
    private WeakReference<ViewGroup> _containerGroup;
    @NotNull
    private final OnApplyWindowInsetsListener windowsInsetsListener;

    public FxAppPlatformProvider(@NotNull FxAppHelper helper, @NotNull FxAppControlImp control) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        this.helper = helper;
        this.control = control;
        this.windowsInsetsListener = (arg_0, arg_1) -> FxAppPlatformProvider.windowsInsetsListener$lambda-0(this, arg_0, arg_1);
        this.checkRegisterAppLifecycle();
    }

    @Override
    @NotNull
    public FxAppHelper getHelper() {
        return this.helper;
    }

    @Override
    @NotNull
    public FxAppControlImp getControl() {
        return this.control;
    }

    private final ViewGroup getContainerGroupView() {
        WeakReference<ViewGroup> weakReference = this._containerGroup;
        return weakReference == null ? null : (ViewGroup)weakReference.get();
    }

    @Override
    @NotNull
    public Context getContext() {
        return (Context)this.getHelper().getContext$floatingx_release();
    }

    @Override
    @Nullable
    public FxDefaultContainerView getInternalView() {
        return this._internalView;
    }

    @Override
    public boolean checkOrInit() {
        this.checkRegisterAppLifecycle();
        Object object = _FxExt.getTopActivity();
        if (object == null) {
            return true;
        }
        Activity act = object;
        if (!this.getHelper().isCanInstall$floatingx_release(act)) {
            this.getHelper().getFxLog$floatingx_release().d("fx not show,This " + act.getClass().getSimpleName() + " is not in the list of allowed inserts!");
            return false;
        }
        if (this._internalView == null) {
            this._internalView = new FxDefaultContainerView(this.getHelper(), (Context)this.getHelper().getContext$floatingx_release(), null, 4, null);
            object = this._internalView;
            if (object != null) {
                ((FxDefaultContainerView)object).initView();
            }
            this.checkOrInitSafeArea(act);
            this.attach(act);
        }
        return true;
    }

    @Override
    public void show() {
        FxDefaultContainerView fxDefaultContainerView = this._internalView;
        if (fxDefaultContainerView == null) {
            return;
        }
        FxDefaultContainerView fxView = fxDefaultContainerView;
        if (!ViewCompat.isAttachedToWindow((View)((View)fxView))) {
            fxView.setVisibility(0);
            fxDefaultContainerView = this.checkOrReInitGroupView();
            if (fxDefaultContainerView != null) {
                _FxExt.safeAddView$default((ViewGroup)fxDefaultContainerView, (View)fxView, null, 2, null);
            }
        } else if (fxView.getVisibility() != 0) {
            fxView.setVisibility(0);
        }
    }

    @Override
    public void hide() {
        this.detach();
    }

    private final ViewGroup checkOrReInitGroupView() {
        Activity activity;
        ViewGroup curGroup = this.getContainerGroupView();
        if (curGroup == null || curGroup != ((activity = _FxExt.getTopActivity()) == null ? null : _FxExt.getDecorView(activity))) {
            activity = _FxExt.getTopActivity();
            this._containerGroup = new WeakReference<FrameLayout>(activity == null ? null : _FxExt.getDecorView(activity));
            this.getHelper().getFxLog$floatingx_release().v("view-----> reinitialize the fx container");
        }
        return this.getContainerGroupView();
    }

    private final boolean attach(Activity activity) {
        FxDefaultContainerView fxDefaultContainerView = this._internalView;
        if (fxDefaultContainerView == null) {
            return false;
        }
        FxDefaultContainerView fxView = fxDefaultContainerView;
        FrameLayout frameLayout = _FxExt.getDecorView(activity);
        if (frameLayout == null) {
            return false;
        }
        FrameLayout decorView = frameLayout;
        if (this.getContainerGroupView() == decorView) {
            return false;
        }
        if (ViewCompat.isAttachedToWindow((View)((View)fxView)) && (frameLayout = this.getContainerGroupView()) != null) {
            _FxExt.safeRemoveView((ViewGroup)frameLayout, (View)fxView);
        }
        this._containerGroup = new WeakReference<FrameLayout>(decorView);
        _FxExt.safeAddView$default((ViewGroup)decorView, (View)fxView, null, 2, null);
        return true;
    }

    public final boolean reAttach(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        FrameLayout frameLayout = _FxExt.getDecorView(activity);
        if (frameLayout == null) {
            return false;
        }
        FrameLayout nContainer = frameLayout;
        if (this._internalView == null) {
            this._containerGroup = new WeakReference<FrameLayout>(nContainer);
            return true;
        }
        if (nContainer == this.getContainerGroupView()) {
            return false;
        }
        frameLayout = this.getContainerGroupView();
        if (frameLayout != null) {
            _FxExt.safeRemoveView((ViewGroup)frameLayout, (View)this._internalView);
        }
        _FxExt.safeAddView$default((ViewGroup)nContainer, (View)this._internalView, null, 2, null);
        this._containerGroup = new WeakReference<FrameLayout>(nContainer);
        return false;
    }

    public final boolean destroyToDetach(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        FxDefaultContainerView fxDefaultContainerView = this._internalView;
        if (fxDefaultContainerView == null) {
            return false;
        }
        FxDefaultContainerView fxView = fxDefaultContainerView;
        ViewGroup viewGroup = this.getContainerGroupView();
        if (viewGroup == null) {
            return false;
        }
        ViewGroup oldContainer = viewGroup;
        if (!ViewCompat.isAttachedToWindow((View)((View)fxView))) {
            return false;
        }
        FrameLayout frameLayout = _FxExt.getDecorView(activity);
        if (frameLayout == null) {
            return false;
        }
        FrameLayout nContainer = frameLayout;
        if (nContainer != oldContainer) {
            return false;
        }
        _FxExt.safeRemoveView(oldContainer, (View)this._internalView);
        return true;
    }

    @Override
    public void reset() {
        this.hide();
        this.clearWindowsInsetsListener();
        this._internalView = null;
        WeakReference<ViewGroup> weakReference = this._containerGroup;
        if (weakReference != null) {
            weakReference.clear();
        }
        this._containerGroup = null;
        this.getHelper().getContext$floatingx_release().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this._lifecycleImp);
        this._lifecycleImp = null;
    }

    private final void detach() {
        Object object = this._internalView;
        if (object != null) {
            object.setVisibility(8);
        }
        object = this.getContainerGroupView();
        if (object != null) {
            _FxExt.safeRemoveView((ViewGroup)object, (View)this._internalView);
        }
        object = this._containerGroup;
        if (object != null) {
            ((Reference)object).clear();
        }
        this._containerGroup = null;
    }

    private final void checkRegisterAppLifecycle() {
        if (!this.getHelper().getEnableFx$floatingx_release() || this._lifecycleImp != null) {
            return;
        }
        this._lifecycleImp = new FxAppLifecycleImp(this.getHelper(), this.getControl());
        this.getHelper().getContext$floatingx_release().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this._lifecycleImp);
    }

    private final void checkOrInitSafeArea(Activity act) {
        if (!this.getHelper().getEnableSafeArea$floatingx_release()) {
            return;
        }
        this.getHelper().updateStatsBar$floatingx_release(act);
        this.getHelper().updateNavigationBar$floatingx_release(act);
        FxDefaultContainerView fxDefaultContainerView = this._internalView;
        if (fxDefaultContainerView == null) {
            return;
        }
        FxDefaultContainerView fxView = fxDefaultContainerView;
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)fxView), (OnApplyWindowInsetsListener)this.windowsInsetsListener);
        fxView.requestApplyInsets();
    }

    private final void clearWindowsInsetsListener() {
        FxDefaultContainerView fxDefaultContainerView = this._internalView;
        if (fxDefaultContainerView == null) {
            return;
        }
        FxDefaultContainerView managerView = fxDefaultContainerView;
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)managerView), null);
    }

    @Override
    @Nullable
    public Boolean isShow() {
        return IFxPlatformProvider.DefaultImpls.isShow(this);
    }

    private static final WindowInsetsCompat windowsInsetsListener$lambda-0(FxAppPlatformProvider this$0, View $noName_0, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int statusBar = insets.getStableInsetTop();
        if (this$0.getHelper().statsBarHeight != statusBar) {
            this$0.getHelper().getFxLog$floatingx_release().v("System--StatusBar---old-(" + this$0.getHelper().statsBarHeight + "),new-(" + statusBar + "))");
            this$0.getHelper().statsBarHeight = statusBar;
        }
        return insets;
    }
}

