/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.view;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.StringRes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ!\u0010\r\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u000e\u001a\u00020\u00002\b\b\u0001\u0010\u000f\u001a\u00020\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u000bJ\u001a\u0010\u0011\u001a\u00020\u00002\b\b\u0001\u0010\u000f\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u000bJ\u0018\u0010\u0013\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0015J\u001a\u0010\u0018\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u001a\u0010\u001b\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u001a\u0010\u001e\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u000bJ\u0018\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!J\u001a\u0010\"\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010$J\u001a\u0010\"\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010%\u001a\u00020\u000bJ\u0018\u0010&\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(J \u0010&\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/petterp/floatingx/view/FxViewHolder;", "", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "getView", "()Landroid/view/View;", "views", "Landroid/util/SparseArray;", "T", "viewId", "", "(I)Landroid/view/View;", "getViewOrNull", "setBackgroundColor", "id", "color", "setBackgroundResource", "source", "setEnabled", "isEnabled", "", "setGone", "isGone", "setImageBitMap", "bitmap", "Landroid/graphics/Bitmap;", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setImageResource", "setOnClickListener", "listener", "Landroid/view/View$OnClickListener;", "setText", "value", "", "resId", "setTextSize", "size", "", "unit", "floatingx_release"})
public final class FxViewHolder {
    @NotNull
    private final View view;
    @NotNull
    private final SparseArray<View> views;

    public FxViewHolder(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.views = new SparseArray();
    }

    @NotNull
    public final View getView() {
        return this.view;
    }

    @NotNull
    public final <T extends View> T getView(@IdRes int viewId) {
        T view = this.getViewOrNull(viewId);
        boolean bl = false;
        boolean bl2 = false;
        if (view == null) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"No view found with id ", (Object)viewId);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return view;
    }

    @Nullable
    public final <T extends View> T getViewOrNull(@IdRes int viewId) {
        View view;
        View view2 = (View)this.views.get(viewId);
        if (view2 == null) {
            View view3 = this.view.findViewById(viewId);
            if (view3 == null) {
                view = null;
            } else {
                View view4 = view3;
                boolean bl = false;
                boolean bl2 = false;
                View it = view4;
                boolean bl3 = false;
                this.views.put(viewId, (Object)it);
                view = it;
            }
        } else {
            view = view2;
        }
        return (T)view;
    }

    @NotNull
    public final FxViewHolder setOnClickListener(@IdRes int viewId, @NotNull View.OnClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getView(viewId).setOnClickListener(listener);
        return this;
    }

    @NotNull
    public final FxViewHolder setText(@IdRes int viewId, @Nullable CharSequence value) {
        ((TextView)this.getView(viewId)).setText(value);
        return this;
    }

    @NotNull
    public final FxViewHolder setText(@IdRes int viewId, @StringRes int resId) {
        ((TextView)this.getView(viewId)).setText(resId);
        return this;
    }

    @NotNull
    public final FxViewHolder setTextSize(@IdRes int viewId, float size) {
        ((TextView)this.getView(viewId)).setTextSize(size);
        return this;
    }

    @NotNull
    public final FxViewHolder setTextSize(@IdRes int viewId, int unit, float size) {
        ((TextView)this.getView(viewId)).setTextSize(unit, size);
        return this;
    }

    @NotNull
    public final FxViewHolder setImageResource(@IdRes int viewId, @DrawableRes int source) {
        ((ImageView)this.getView(viewId)).setImageResource(source);
        return this;
    }

    @NotNull
    public final FxViewHolder setImageBitMap(@IdRes int viewId, @Nullable Bitmap bitmap) {
        ((ImageView)this.getView(viewId)).setImageBitmap(bitmap);
        return this;
    }

    @NotNull
    public final FxViewHolder setImageDrawable(@IdRes int viewId, @Nullable Drawable drawable) {
        ((ImageView)this.getView(viewId)).setImageDrawable(drawable);
        return this;
    }

    @NotNull
    public final FxViewHolder setBackgroundResource(@IdRes int id2, @DrawableRes int source) {
        this.getView(id2).setBackgroundResource(source);
        return this;
    }

    @NotNull
    public final FxViewHolder setBackgroundColor(@IdRes int id2, @ColorInt int color) {
        this.getView(id2).setBackgroundColor(color);
        return this;
    }

    @NotNull
    public final FxViewHolder setGone(@IdRes int viewId, boolean isGone) {
        Object view = this.getView(viewId);
        view.setVisibility(isGone ? 8 : 0);
        return this;
    }

    @NotNull
    public final FxViewHolder setEnabled(@IdRes int viewId, boolean isEnabled) {
        this.getView(viewId).setEnabled(isEnabled);
        return this;
    }
}

