/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.phillima.asniffer.AmFactory;
import com.github.phillima.asniffer.model.AMReport;
import com.github.phillima.asniffer.output.IReport;
import com.github.phillima.asniffer.utils.FileUtils;
import com.github.phillima.asniffer.utils.ReportTypeUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ASniffer {
    private String projectsPath = "";
    private String reportPath = "";
    private IReport reportType;
    private static final Logger logger = LogManager.getLogger(ASniffer.class);

    public ASniffer(String projectPath, String reportPath, IReport reportType) {
        this.projectsPath = projectPath;
        this.reportPath = reportPath;
        this.reportType = reportType;
    }

    public ASniffer(String projectPath, String reportPath) {
        this.projectsPath = projectPath;
        this.reportPath = reportPath;
        this.reportType = ReportTypeUtils.getReportInstance("json");
    }

    public List<AMReport> collectMultiple() {
        ArrayList<AMReport> reports = new ArrayList<AMReport>();
        for (Path projectPath : FileUtils.getProjectsPath(this.projectsPath)) {
            reports.add(this.collect(projectPath));
        }
        return reports;
    }

    public AMReport collectSingle() {
        return this.collect(Paths.get(this.projectsPath, new String[0]));
    }

    private AMReport collect(Path projectPath) {
        StaticJavaParser.setConfiguration((ParserConfiguration)StaticJavaParser.getConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17_PREVIEW));
        String projectName = FileUtils.getProjectName(projectPath);
        logger.info("Initializing extraction for project " + projectName);
        AMReport report = AmFactory.createAm(projectPath.toString(), projectName).calculate();
        logger.info("Extraction concluded for project " + projectName);
        this.generateOutput(report);
        return report;
    }

    private void generateOutput(AMReport report) {
        this.reportType.generateReport(report, this.reportPath);
    }
}

