/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer;

import com.github.phillima.asniffer.AM;
import com.github.phillima.asniffer.MetricsExecutor;
import com.github.phillima.asniffer.interfaces.IAnnotationMetricCollector;
import com.github.phillima.asniffer.interfaces.IClassMetricCollector;
import com.github.phillima.asniffer.interfaces.ICodeElementMetricCollector;
import com.github.phillima.asniffer.metric.AA;
import com.github.phillima.asniffer.metric.AC;
import com.github.phillima.asniffer.metric.AED;
import com.github.phillima.asniffer.metric.ANL;
import com.github.phillima.asniffer.metric.ASC;
import com.github.phillima.asniffer.metric.LOCAD;
import com.github.phillima.asniffer.metric.NAEC;
import com.github.phillima.asniffer.metric.UAC;
import com.github.phillima.asniffer.utils.FileUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class AmFactory {
    private static final int MIN_NUMBER_FILES_TO_PARALLEL = 5000;
    private static final int MIN_NUMBER_TO_PARTITIONS = 10000;

    private AmFactory() {
    }

    public static final AM createAm(String path, String projectName) {
        String[] javaFiles = FileUtils.getAllJavaFiles(path);
        MetricsExecutor storage = new MetricsExecutor(() -> AmFactory.includeClassMetrics(), AmFactory.includeAnnotationMetrics(), AmFactory.includeCodeElementMetrics(), projectName);
        Stream<Stream<String>> stream = AmFactory.generatePartitionsStream(javaFiles);
        return new AM(storage, stream);
    }

    private static Stream<Stream<String>> generatePartitionsStream(String[] javaFiles) {
        int numberPartitions = javaFiles.length / 10000 + 1;
        List partitions = Lists.partition(List.of(javaFiles), (int)numberPartitions);
        return AmFactory.generateStream(partitions, javaFiles.length, numberPartitions);
    }

    private static Stream<Stream<String>> generateStream(List<List<String>> javaFiles, int files, int partitions) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (files >= 5000 * partitions && availableProcessors > 1) {
            return javaFiles.stream().map(it -> (Stream)it.stream().parallel());
        }
        return javaFiles.stream().map(Collection::stream);
    }

    private static List<IClassMetricCollector> includeClassMetrics() {
        ArrayList<IClassMetricCollector> metrics = new ArrayList<IClassMetricCollector>();
        metrics.add(new AC());
        metrics.add(new UAC());
        metrics.add(new ASC());
        metrics.add(new NAEC());
        return metrics;
    }

    private static List<IAnnotationMetricCollector> includeAnnotationMetrics() {
        ArrayList<IAnnotationMetricCollector> metrics = new ArrayList<IAnnotationMetricCollector>();
        metrics.add(new AA());
        metrics.add(new ANL());
        metrics.add(new LOCAD());
        return metrics;
    }

    private static List<ICodeElementMetricCollector> includeCodeElementMetrics() {
        ArrayList<ICodeElementMetricCollector> metrics = new ArrayList<ICodeElementMetricCollector>();
        metrics.add(new AED());
        return metrics;
    }
}

