/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.phillima.asniffer.model.CodeElementModel;
import com.github.phillima.asniffer.model.CodeElementType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ClassInfo
extends VoidVisitorAdapter<Object> {
    private CompilationUnit cu;
    private String className = null;
    private CodeElementType type;
    private Map<Node, CodeElementModel> codeElementsInfo;
    private String packageName;

    public ClassInfo(CompilationUnit cu) {
        this.cu = cu;
        this.codeElementsInfo = new ConcurrentHashMap<Node, CodeElementModel>();
    }

    public void visit(CompilationUnit node, Object obj) {
        this.getFullClassName((Node)node);
        super.visit(node, obj);
    }

    public void visit(ClassOrInterfaceDeclaration node, Object obj) {
        CodeElementType innerType = node.isInterface() ? CodeElementType.INTERFACE : CodeElementType.CLASS;
        CodeElementModel codeElementModel = new CodeElementModel(node.getName().getIdentifier(), innerType, this.getLineStart((Node)node));
        this.codeElementsInfo.put((Node)node, codeElementModel);
        super.visit(node, obj);
    }

    public void visit(EnumDeclaration node, Object obj) {
        CodeElementType innerType = CodeElementType.ENUM;
        CodeElementModel codeElementModel = new CodeElementModel(node.getName().getIdentifier(), innerType, this.getLineStart((Node)node));
        this.codeElementsInfo.put((Node)node, codeElementModel);
        super.visit(node, obj);
    }

    public void visit(AnnotationDeclaration node, Object obj) {
        CodeElementType innerType = CodeElementType.ANNOTATION_DECLARATION;
        CodeElementModel codeElementModel = new CodeElementModel(node.getName().getIdentifier(), innerType, this.getLineStart((Node)node));
        this.codeElementsInfo.put((Node)node, codeElementModel);
        super.visit(node, obj);
    }

    public void visit(MethodDeclaration node, Object obj) {
        CodeElementType innerType = CodeElementType.METHOD;
        CodeElementModel codeElementModel = new CodeElementModel(node.getName().getIdentifier(), innerType, this.getLineStart((Node)node));
        this.codeElementsInfo.put((Node)node, codeElementModel);
        super.visit(node, obj);
    }

    public void visit(ConstructorDeclaration node, Object obj) {
        CodeElementType innerType = CodeElementType.CONSTRUCTOR;
        CodeElementModel codeElementModel = new CodeElementModel(node.getName().getIdentifier(), innerType, this.getLineStart((Node)node));
        this.codeElementsInfo.put((Node)node, codeElementModel);
        super.visit(node, obj);
    }

    public void visit(FieldDeclaration node, Object obj) {
        CodeElementType innerType = CodeElementType.FIELD;
        String fieldName = node.getVariables().getFirst().map(VariableDeclarator::getName).toString();
        CodeElementModel codeElementModel = new CodeElementModel(fieldName, innerType, this.getLineStart((Node)node));
        this.codeElementsInfo.put((Node)node, codeElementModel);
        super.visit(node, obj);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public CodeElementType getType() {
        return this.type;
    }

    public Map<Node, CodeElementModel> getCodeElementsInfo() {
        return this.codeElementsInfo;
    }

    private String getFullClassName(Node node) {
        if (node instanceof CompilationUnit) {
            ((CompilationUnit)node).getPrimaryType().ifPresent(typeDeclaration -> {
                this.defineTypeInClassInfo((TypeDeclaration<?>)typeDeclaration);
                this.cu.getPackageDeclaration().ifPresent(packageDeclaration -> {
                    this.packageName = packageDeclaration.getNameAsString();
                });
                this.className = this.generateClassName();
            });
        }
        return null;
    }

    private String generateClassName() {
        return ((PackageDeclaration)this.cu.getPackageDeclaration().get()).getName() + "." + (String)this.cu.getPrimaryTypeName().get();
    }

    private void defineTypeInClassInfo(TypeDeclaration<?> typeDeclaration) {
        if (typeDeclaration.isAnnotationDeclaration()) {
            this.type = CodeElementType.ANNOTATION_DECLARATION;
        } else if (typeDeclaration.isEnumDeclaration() || typeDeclaration.isEnumConstantDeclaration()) {
            this.type = CodeElementType.ENUM;
        } else if (typeDeclaration.isClassOrInterfaceDeclaration()) {
            this.type = typeDeclaration.asClassOrInterfaceDeclaration().isInterface() ? CodeElementType.INTERFACE : CodeElementType.CLASS;
        }
    }

    private Integer getLineStart(Node node) {
        Optional tokenRange = node.getTokenRange();
        if (tokenRange.isPresent()) {
            return ((TokenRange)tokenRange.get()).toRange().map(range -> range.begin.line).orElse(-1);
        }
        throw new RuntimeException("Exists a node without a range");
    }
}

