/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer;

import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.phillima.asniffer.ClassInfo;
import com.github.phillima.asniffer.interfaces.IAnnotationMetricCollector;
import com.github.phillima.asniffer.interfaces.IClassMetricCollector;
import com.github.phillima.asniffer.interfaces.ICodeElementMetricCollector;
import com.github.phillima.asniffer.metric.LOCCalculator;
import com.github.phillima.asniffer.model.AMReport;
import com.github.phillima.asniffer.model.AnnotationMetricModel;
import com.github.phillima.asniffer.model.ClassModel;
import com.github.phillima.asniffer.model.CodeElementModel;
import com.github.phillima.asniffer.model.PackageModel;
import com.github.phillima.asniffer.utils.AnnotationUtils;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetricsExecutor {
    private AMReport report;
    private Map<String, PackageModel> packagesModel;
    private ClassModel result = null;
    private Callable<List<IClassMetricCollector>> classMetrics;
    private List<IAnnotationMetricCollector> annotationMetrics;
    private List<ICodeElementMetricCollector> codeElementMetrics;
    private static final Logger logger = LogManager.getLogger(MetricsExecutor.class);

    public MetricsExecutor(Callable<List<IClassMetricCollector>> classMetrics, List<IAnnotationMetricCollector> annotationMetrics, List<ICodeElementMetricCollector> codeElementMetrics, String projectName) {
        this.classMetrics = classMetrics;
        this.annotationMetrics = annotationMetrics;
        this.codeElementMetrics = codeElementMetrics;
        this.report = new AMReport(projectName);
        this.packagesModel = new HashMap<String, PackageModel>();
    }

    public void accept(List<CompilationUnit> compilationUnitList) {
        compilationUnitList.forEach(cu -> {
            try {
                ClassInfo info = new ClassInfo((CompilationUnit)cu);
                cu.accept((VoidVisitor)info, null);
                if (info.getClassName() == null) {
                    return;
                }
                String packageName = info.getPackageName();
                PackageModel packageModel = this.getPackageModel(packageName);
                String sourceFilePath = ((CompilationUnit.Storage)cu.getStorage().get()).getPath().toString();
                int loc = new LOCCalculator().calculate(new FileInputStream(sourceFilePath));
                int nec = info.getCodeElementsInfo().size();
                this.result = new ClassModel(sourceFilePath, info.getClassName(), info.getType(), loc, nec);
                logger.info("Initializing extraction of class metrics for class: " + info.getClassName());
                for (IClassMetricCollector visitor : this.classMetrics.call()) {
                    visitor.execute((CompilationUnit)cu, this.result, this.report);
                    visitor.setResult(this.result);
                }
                logger.info("Finished extracting class metrics.");
                info.getCodeElementsInfo().entrySet().forEach(entry -> {
                    Node codeElementBody = (Node)entry.getKey();
                    CodeElementModel codeElementModel = (CodeElementModel)entry.getValue();
                    logger.info("Initializing extraction of code element metrics for element: " + codeElementModel.getElementName());
                    for (ICodeElementMetricCollector visitor : this.codeElementMetrics) {
                        visitor.execute((CompilationUnit)cu, codeElementModel, codeElementBody);
                    }
                    logger.info("Finished extraction of code element metrics for element: " + codeElementModel.getElementName());
                    List<AnnotationExpr> annotations = AnnotationUtils.checkForAnnotations(codeElementBody);
                    logger.info("Initializing extraction of annotation metrics for code element: " + codeElementModel.getElementName());
                    annotations.forEach(annotation -> {
                        AnnotationMetricModel annotationMetricModel = new AnnotationMetricModel(annotation.getName().getIdentifier(), ((Range)((TokenRange)annotation.getTokenRange().get()).toRange().get()).begin.line, this.result.getAnnotationSchema(annotation.getName().getIdentifier() + "-" + ((Range)((TokenRange)annotation.getTokenRange().get()).toRange().get()).begin.line));
                        for (IAnnotationMetricCollector annotationCollector : this.annotationMetrics) {
                            annotationCollector.execute((CompilationUnit)cu, annotationMetricModel, (AnnotationExpr)annotation);
                        }
                        codeElementModel.addAnnotationMetric(annotationMetricModel);
                    });
                    logger.info("Finished extraction of annotation metrics for code element: " + codeElementModel.getElementName());
                    this.result.addElementReport(codeElementModel);
                });
                packageModel.addClassModel(this.result);
                this.report.addPackageModel(packageModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public AMReport getReport() {
        return this.report;
    }

    private PackageModel getPackageModel(String packageName) {
        if (this.packagesModel.containsKey(packageName)) {
            return this.packagesModel.get(packageName);
        }
        PackageModel packageModel = new PackageModel(packageName);
        this.packagesModel.put(packageName, packageModel);
        return packageModel;
    }
}

