/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.metric;

import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.phillima.asniffer.interfaces.IClassMetricCollector;
import com.github.phillima.asniffer.model.AMReport;
import com.github.phillima.asniffer.model.ClassModel;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ASC
extends VoidVisitorAdapter<Object>
implements IClassMetricCollector {
    List<ImportDeclaration> imports = new ArrayList<ImportDeclaration>();
    HashMap<String, String> schemasMapper = new HashMap();
    CompilationUnit cu;
    private static Set<String> javaLangPredefined = ImmutableSet.of((Object)"Override", (Object)"Deprecated", (Object)"SuppressWarnings", (Object)"SafeVarargs", (Object)"FunctionalInterface");

    public void visit(MarkerAnnotationExpr node, Object obj) {
        this.findSchema((AnnotationExpr)node);
        super.visit(node, obj);
    }

    public void visit(NormalAnnotationExpr node, Object obj) {
        this.findSchema((AnnotationExpr)node);
        super.visit(node, obj);
    }

    public void visit(SingleMemberAnnotationExpr node, Object obj) {
        this.findSchema((AnnotationExpr)node);
        super.visit(node, obj);
    }

    @Override
    public void execute(CompilationUnit cu, ClassModel result, AMReport report) {
        this.findImports(cu);
        this.cu = cu;
        this.visit(cu, null);
    }

    @Override
    public void setResult(ClassModel result) {
        result.setSchemas(this.schemasMapper);
        result.addClassMetric("ASC", result.getAnnotationSchemas().size());
    }

    private void findSchema(AnnotationExpr annotation) {
        String qualifier = annotation.getName().getQualifier().isPresent() ? this.getQualifier(annotation) : "";
        int annotationLineNumber = ((Range)((TokenRange)annotation.getTokenRange().get()).toRange().get()).begin.line;
        String annotationName = qualifier.isEmpty() ? annotation.getNameAsString() : annotation.getName().asString().replaceFirst(qualifier.concat("\\."), "");
        String annotationNameAndLine = annotationName + "-" + annotationLineNumber;
        if (!qualifier.isEmpty()) {
            this.schemasMapper.put(annotationNameAndLine, qualifier);
            return;
        }
        for (ImportDeclaration import_ : this.imports) {
            String annotationNameTemp = annotationName;
            if (annotationName.contains(".")) {
                annotationNameTemp = annotationName.substring(0, annotationName.indexOf("."));
            }
            if (!import_.getName().getIdentifier().equals(annotationNameTemp)) continue;
            import_.getName().getQualifier().ifPresent(s -> this.schemasMapper.put(annotationNameAndLine, s.toString()));
            return;
        }
        String schema = "";
        schema = javaLangPredefined.contains(annotation.getNameAsString()) ? "java.lang" : ((PackageDeclaration)this.cu.getPackageDeclaration().get()).getNameAsString();
        this.schemasMapper.put(annotationNameAndLine, schema);
    }

    private String getQualifier(AnnotationExpr annotation) {
        Name qualifier = (Name)annotation.getName().getQualifier().get();
        while (Character.isUpperCase(qualifier.getId().charAt(0))) {
            if (qualifier.getQualifier().isPresent()) {
                qualifier = (Name)qualifier.getQualifier().get();
                continue;
            }
            return "";
        }
        return qualifier.asString();
    }

    private void findImports(CompilationUnit cu) {
        for (ImportDeclaration import_ : cu.getImports()) {
            if (import_.isStatic()) continue;
            this.imports.add(import_);
        }
    }
}

