/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.model;

import com.github.phillima.asniffer.model.CodeElementModel;
import com.github.phillima.asniffer.model.CodeElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassModel {
    private String sourceFilePath;
    private String className;
    private CodeElementType type;
    private HashMap<String, String> annotSchemasMap;
    private Map<String, Integer> classMetric;
    private List<CodeElementModel> elementsReport;

    public ClassModel(String sourceFilePath, String className, CodeElementType type, int loc, int nec) {
        this.sourceFilePath = sourceFilePath;
        this.className = className;
        this.type = type;
        this.classMetric = new HashMap<String, Integer>();
        this.elementsReport = new ArrayList<CodeElementModel>();
        this.addClassMetric("LOC", loc);
        this.addClassMetric("NEC", nec);
        this.annotSchemasMap = new HashMap();
    }

    public int getClassMetric(String metricName) {
        if (this.classMetric.containsKey(metricName)) {
            return this.classMetric.get(metricName);
        }
        return -1;
    }

    public void addClassMetric(String metricName, int metricValue) {
        this.classMetric.put(metricName, metricValue);
    }

    public void addAnnotationSchema(String fullyqualifiedName, String simpleName) {
        this.annotSchemasMap.put(fullyqualifiedName, simpleName);
    }

    public CodeElementModel getElementReport(String elementName) {
        return this.elementsReport.stream().filter(e -> e.getElementName().equals(elementName)).findFirst().get();
    }

    public CodeElementModel getElementReport(String elementName, CodeElementType elementType) {
        return this.elementsReport.stream().filter(e -> e.getElementName().equals(elementName)).filter(e -> e.getType().equals((Object)elementType)).findFirst().get();
    }

    public void addElementReport(CodeElementModel elementReport) {
        this.elementsReport.add(elementReport);
    }

    public String getAnnotationSchema(String annotationName) {
        if (this.annotSchemasMap.containsKey(annotationName)) {
            return this.annotSchemasMap.get(annotationName);
        }
        return null;
    }

    public String getSimpleName() {
        int lastIndex = this.className.lastIndexOf(".");
        if (lastIndex != -1) {
            return this.className.substring(lastIndex + 1);
        }
        return this.className;
    }

    public String getFullyQualifiedName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public CodeElementType getType() {
        return this.type;
    }

    public void setType(CodeElementType type) {
        this.type = type;
    }

    public List<CodeElementModel> getElementsReport() {
        return this.elementsReport;
    }

    public Map<String, Integer> getAllClassMetrics() {
        return this.classMetric;
    }

    public Set<String> getAnnotationSchemas() {
        HashSet<String> schemas = new HashSet<String>();
        this.annotSchemasMap.forEach((k, v) -> schemas.add((String)v));
        return schemas;
    }

    public HashMap<String, String> getAnnotationSchemasMap() {
        return this.annotSchemasMap;
    }

    public void setSchemas(HashMap<String, String> annotationSchemas) {
        this.annotSchemasMap = annotationSchemas;
    }
}

