/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.output.json.d3hierarchy.systemview;

import com.github.phillima.asniffer.model.AMReport;
import com.github.phillima.asniffer.output.IReport;
import com.github.phillima.asniffer.output.json.d3hierarchy.FetchSystemViewIMP;
import com.github.phillima.asniffer.output.json.d3hierarchy.ProjectReport;
import com.github.phillima.asniffer.utils.ReportTypeUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class JSONReportSV
implements IReport {
    private ProjectReport projectReportJson;

    @Override
    public void generateReport(AMReport report, String path) {
        this.projectReportJson = this.prepareJson(report);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path jsonFilePath = Paths.get(path + File.separator + report.getProjectName() + "-SV.json", new String[0]).normalize();
        String json = gson.toJson((Object)this.projectReportJson);
        try {
            FileWriter writer = new FileWriter(jsonFilePath.toString());
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ProjectReport prepareJson(AMReport report) {
        ProjectReport projectReportJson = new ProjectReport(report.getProjectName());
        projectReportJson.addPackages(ReportTypeUtils.fetchPackages(report.getPackages(), new FetchSystemViewIMP()));
        return projectReportJson;
    }
}

