/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.parameters;

import com.github.phillima.asniffer.parameters.ParameterReadingException;
import com.github.phillima.asniffer.parameters.container.IsParameterPresentContainer;
import com.github.phillima.asniffer.parameters.container.ParamMapperContainer;
import com.github.phillima.asniffer.parameters.container.TextValueContainer;
import java.util.HashMap;
import net.sf.esfinge.metadata.AnnotationReader;
import org.apache.commons.beanutils.BeanUtils;

public class ParamMapper {
    public <E> E map(String[] args, Class<E> paramClass) {
        ParamMapperContainer c = this.readMetadata(paramClass);
        Object paramInstance = this.readParameters(args, c);
        return (E)paramInstance;
    }

    private ParamMapperContainer readMetadata(Class<?> paramClass) {
        AnnotationReader reader = new AnnotationReader();
        ParamMapperContainer container = null;
        try {
            container = (ParamMapperContainer)reader.readingAnnotationsTo(paramClass, ParamMapperContainer.class);
            container.setClassToParameter(paramClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return container;
    }

    private Object readParameters(String[] args, ParamMapperContainer c) {
        if (!args[0].startsWith("-")) {
            throw new ParameterReadingException("Cannot start with a value");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (args.length != 0) {
            int i = 0;
            while (i < args.length) {
                String key = args[i++].substring(1);
                Object value = "";
                while (i < args.length && !args[i].startsWith("-")) {
                    value = (String)value + args[i++] + " ";
                }
                parameters.put(key, ((String)value).trim());
            }
        }
        try {
            Object o = c.getClassToParameter().newInstance();
            for (IsParameterPresentContainer ipContainer : c.getFieldsWithIsPresent()) {
                BeanUtils.setProperty(o, (String)ipContainer.getName(), (Object)false);
                for (String argument : args) {
                    if (!argument.equals("-" + ipContainer.getValue())) continue;
                    BeanUtils.setProperty(o, (String)ipContainer.getName(), (Object)true);
                }
            }
            for (TextValueContainer tvContainer : c.getFieldsWithTextValue()) {
                if (parameters.containsKey(tvContainer.getValue())) {
                    if (tvContainer.isMandatory() && ((String)parameters.get(tvContainer.getValue())).isEmpty()) {
                        throw new ParameterReadingException("Parameter: -" + tvContainer.getValue() + " is empty. Please provided a value for field: " + tvContainer.getName());
                    }
                    try {
                        BeanUtils.setProperty(o, (String)tvContainer.getName(), parameters.get(tvContainer.getValue()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!tvContainer.isMandatory()) continue;
                throw new ParameterReadingException("Parameter: -" + tvContainer.getValue() + " is mandatory. Please provided a value for field: " + tvContainer.getName());
            }
            return o;
        }
        catch (Exception e) {
            throw new ParameterReadingException("Cannot instantiate parameter class", e);
        }
    }
}

