/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.parameters;

import com.github.phillima.asniffer.annotations.IsParameterPresent;
import com.github.phillima.asniffer.annotations.Mandatory;
import com.github.phillima.asniffer.annotations.TextValue;

public class Parameters {
    public static final String DEFAULT_PROJECT_REPORT = "json";
    public static final String DEFAULT_SINGLE_MULTI = "single";
    @IsParameterPresent(name="p")
    private boolean projPathPresent;
    @Mandatory
    @TextValue(name="p")
    private String projectPath;
    @IsParameterPresent(name="r")
    private boolean reportPathPresent;
    @TextValue(name="r")
    private String reportPath;
    @IsParameterPresent(name="t")
    private boolean reportTypePresent;
    @TextValue(name="t")
    private String reportType;
    @IsParameterPresent(name="m")
    private boolean multiProjectPresent;
    @TextValue(name="m")
    private String multiProject;

    public String getMultiProject() {
        if (this.isMultiProjectPresent() && !this.multiProject.isEmpty()) {
            return this.multiProject;
        }
        return DEFAULT_SINGLE_MULTI;
    }

    public void setMultiProject(String multiProject) {
        this.multiProject = multiProject;
    }

    public boolean isReportTypePresent() {
        return this.reportTypePresent;
    }

    public void setReportTypePresent(boolean reportTypePresent) {
        this.reportTypePresent = reportTypePresent;
    }

    public boolean isMultiProjectPresent() {
        return this.multiProjectPresent;
    }

    public void setMultiProjectPresent(boolean multiProjectPresent) {
        this.multiProjectPresent = multiProjectPresent;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getReportPath() {
        if (this.isReportPathPresent() && !this.reportPath.isEmpty()) {
            return this.reportPath;
        }
        return this.getProjectPath();
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public String getReportType() {
        if (this.isReportTypePresent() && !this.reportType.isEmpty()) {
            return this.reportType;
        }
        return DEFAULT_PROJECT_REPORT;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public boolean isProjPathPresent() {
        return this.projPathPresent;
    }

    public void setProjPathPresent(boolean projPathPresent) {
        this.projPathPresent = projPathPresent;
    }

    public boolean isReportPathPresent() {
        return this.reportPathPresent;
    }

    public void setReportPathPresent(boolean reportPathPresent) {
        this.reportPathPresent = reportPathPresent;
    }

    public boolean isAMultiProject() {
        return this.getMultiProject().equalsIgnoreCase("multi");
    }
}

