/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.utils;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AnnotationUtils {
    public static List<AnnotationExpr> checkForAnnotations(Node node) {
        ArrayList<AnnotationExpr> annotations = new ArrayList<AnnotationExpr>();
        if (node instanceof NodeWithAnnotations) {
            NodeWithAnnotations nodeWithAnnotations = (NodeWithAnnotations)node;
            ListIterator it = nodeWithAnnotations.getAnnotations().listIterator();
            while (it.hasNext()) {
                AnnotationExpr annotationExpr = (AnnotationExpr)it.next();
                AnnotationUtils.checkForNestedAnnotations(annotations, annotationExpr);
            }
            if (nodeWithAnnotations instanceof NodeWithParameters) {
                AnnotationUtils.checkForParametersWithAnnotations(annotations, (NodeWithParameters<Node>)((NodeWithParameters)nodeWithAnnotations));
            }
        }
        return annotations;
    }

    private static void checkForParametersWithAnnotations(List<AnnotationExpr> annotations, NodeWithParameters<Node> node) {
        node.getParameters().forEach(it -> {
            if (it instanceof NodeWithAnnotations) {
                it.getAnnotations().forEach(annotation -> annotations.add((AnnotationExpr)annotation));
            }
        });
    }

    public static void checkForNestedAnnotations(List<AnnotationExpr> annotations, AnnotationExpr annotation) {
        annotations.add(annotation);
        if (annotation instanceof NormalAnnotationExpr) {
            NodeList arguments = ((NormalAnnotationExpr)annotation).getPairs();
            for (MemberValuePair value : arguments) {
                Expression argArray = value.getValue();
                if (argArray instanceof ArrayInitializerExpr) {
                    for (Object memberValuePair : ((ArrayInitializerExpr)argArray).getValues()) {
                        if (!(memberValuePair instanceof AnnotationExpr)) continue;
                        AnnotationUtils.checkForNestedAnnotations(annotations, (AnnotationExpr)memberValuePair);
                    }
                    continue;
                }
                if (!(argArray instanceof AnnotationExpr)) continue;
                AnnotationUtils.checkForNestedAnnotations(annotations, (AnnotationExpr)argArray);
            }
        }
    }
}

