/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class FileUtils {
    public static String[] getAllDirs(String path) {
        ArrayList<String> dirs = new ArrayList<String>();
        FileUtils.getAllDirs(path, dirs);
        String[] ar = new String[dirs.size()];
        ar = dirs.toArray(ar);
        return ar;
    }

    private static void getAllDirs(String path, ArrayList<String> dirs) {
        File f = new File(path);
        if (f.getName().equals(".git")) {
            return;
        }
        for (File inside : f.listFiles()) {
            if (!inside.isDirectory()) continue;
            String newDir = inside.getAbsolutePath();
            dirs.add(newDir);
            FileUtils.getAllDirs(newDir, dirs);
        }
    }

    public static String[] getAllJavaFiles(String path) {
        ArrayList<String> files = new ArrayList<String>();
        FileUtils.getAllJavaFiles(path, files);
        String[] ar = new String[files.size()];
        ar = files.toArray(ar);
        return ar;
    }

    private static void getAllJavaFiles(String path, ArrayList<String> files) {
        File f = new File(path);
        if (f.isHidden()) {
            return;
        }
        for (File inside : f.listFiles()) {
            if (inside.isDirectory()) {
                String newDir = inside.getAbsolutePath();
                FileUtils.getAllJavaFiles(newDir, files);
                continue;
            }
            if (!inside.getAbsolutePath().toLowerCase().endsWith(".java")) continue;
            files.add(inside.getAbsolutePath());
        }
    }

    public static List<Path> getProjectsPath(String projectPath) {
        ArrayList<Path> projectsPaths = new ArrayList<Path>();
        try {
            Files.list(Paths.get(projectPath, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(projectsPaths::add);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return projectsPaths;
    }

    public static String getProjectName(Path projectPath) {
        return String.valueOf(projectPath.getFileName());
    }

    public static String getFileAsString(String path) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }
}

