/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillima.asniffer.utils;

import com.github.phillima.asniffer.exceptions.ReportTypeException;
import com.github.phillima.asniffer.model.CodeElementType;
import com.github.phillima.asniffer.model.PackageModel;
import com.github.phillima.asniffer.output.IReport;
import com.github.phillima.asniffer.output.json.d3hierarchy.Children;
import com.github.phillima.asniffer.output.json.d3hierarchy.IFetchChildren;
import com.github.phillima.asniffer.utils.PropertiesUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class ReportTypeUtils {
    public static IReport getReportInstance(String reportType) {
        Object reportInstance = null;
        String classReport = "";
        try {
            classReport = PropertiesUtil.getReportType(reportType);
            Class<?> reportClazz = Class.forName(classReport);
            reportInstance = reportClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (reportInstance instanceof IReport) {
            return reportInstance;
        }
        throw new ReportTypeException("Report Type class" + classReport + " does not implement IReport interface");
    }

    public static boolean isParentPackage(String rootPackageName, String currentPackageName) {
        String[] splitCurrentPackageName;
        int currentPackageLen;
        String[] splitRootPackage = rootPackageName.split("\\.");
        int rootPackageLen = splitRootPackage.length;
        if (rootPackageLen >= (currentPackageLen = (splitCurrentPackageName = currentPackageName.split("\\.")).length)) {
            return false;
        }
        for (int i = 0; i < rootPackageLen; ++i) {
            if (splitCurrentPackageName[i].equals(splitRootPackage[i])) continue;
            return false;
        }
        return true;
    }

    public static List<Children> fetchPackages(List<PackageModel> packages, IFetchChildren fetchChildren) {
        ArrayList<Children> packageContents = new ArrayList<Children>();
        Stack<Children> packageContentStack = new Stack<Children>();
        ArrayList<PackageModel> orderedPackModel = new ArrayList<PackageModel>(packages);
        Collections.sort(orderedPackModel);
        String rootPackageName = null;
        for (PackageModel packageModel : orderedPackModel) {
            String packageParentName;
            Children packageContent = new Children(packageModel.getPackageName(), CodeElementType.PACKAGE, null);
            packageContent.addAllChidren(fetchChildren.fetchChildren(packageModel));
            if (packageContentStack.isEmpty()) {
                packageContentStack.push(packageContent);
                rootPackageName = packageContent.getName();
                packageContents.add(packageContent);
                continue;
            }
            int previousPackageLvl = packageModel.getPackageName().lastIndexOf(".");
            if (previousPackageLvl == -1) {
                previousPackageLvl = packageModel.getPackageName().length();
            }
            if (rootPackageName.equals(packageParentName = packageModel.getPackageName().substring(0, previousPackageLvl))) {
                ((Children)packageContentStack.peek()).addChildren(packageContent);
                continue;
            }
            if (ReportTypeUtils.isParentPackage(rootPackageName, packageContent.getName())) {
                Children newRootPackage = ((Children)packageContentStack.peek()).getChildByName(packageParentName);
                if (newRootPackage != null) {
                    rootPackageName = packageParentName;
                    newRootPackage.addChildren(packageContent);
                    packageContentStack.push(newRootPackage);
                    continue;
                }
                ((Children)packageContentStack.peek()).addChildren(packageContent);
                continue;
            }
            while (!packageContentStack.isEmpty() && !ReportTypeUtils.isParentPackage(((Children)packageContentStack.peek()).getName(), packageContent.getName())) {
                packageContentStack.pop();
            }
            if (packageContentStack.isEmpty()) {
                packageContentStack.push(packageContent);
                packageContents.add(packageContent);
                rootPackageName = packageContent.getName();
                continue;
            }
            ((Children)packageContentStack.peek()).addChildren(packageContent);
            rootPackageName = ((Children)packageContentStack.peek()).getName();
        }
        return packageContents;
    }
}

