/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.plugin.goview.config;

import cn.hutool.core.util.StrUtil;
import io.springboot.plugin.goview.config.TenantContextHolder;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.filter.GenericFilterBean;

public class TenantContextHolderFilter
extends GenericFilterBean
implements Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantContextHolderFilter.class);
    private static final String UNDEFINED_STR = "undefined";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String headerTenantId = request.getHeader("Tenant-Id");
        String paramTenantId = request.getParameter("tenantId");
        log.debug("\u83b7\u53d6header\u4e2d\u7684\u79df\u6237ID\u4e3a:{}", (Object)headerTenantId);
        if (StrUtil.isNotBlank((CharSequence)headerTenantId) && !StrUtil.equals((CharSequence)UNDEFINED_STR, (CharSequence)headerTenantId)) {
            TenantContextHolder.setTenantId(Long.parseLong(headerTenantId));
        } else if (StrUtil.isNotBlank((CharSequence)paramTenantId) && !StrUtil.equals((CharSequence)UNDEFINED_STR, (CharSequence)paramTenantId)) {
            TenantContextHolder.setTenantId(Long.parseLong(paramTenantId));
        } else {
            TenantContextHolder.setTenantId(1L);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        TenantContextHolder.clear();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

