/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.authenticate.DefaultAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.authenticate.IAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class NacosAuthPluginService
implements AuthPluginService {
    @Deprecated
    private static final String USER_IDENTITY_PARAM_KEY = "user";
    private static final List<String> IDENTITY_NAMES = new LinkedList<String>(){
        {
            this.add("Authorization");
            this.add("accessToken");
            this.add("username");
            this.add("password");
        }
    };
    protected IAuthenticationManager authenticationManager;

    public Collection<String> identityNames() {
        return IDENTITY_NAMES;
    }

    public boolean enableAuth(ActionTypes action, String type) {
        return true;
    }

    public boolean validateIdentity(IdentityContext identityContext, Resource resource) throws AccessException {
        NacosUser nacosUser;
        this.checkNacosAuthManager();
        String token = this.resolveToken(identityContext);
        if (StringUtils.isNotBlank((String)token)) {
            nacosUser = this.authenticationManager.authenticate(token);
        } else {
            String userName = (String)identityContext.getParameter("username");
            String password = (String)identityContext.getParameter("password");
            nacosUser = this.authenticationManager.authenticate(userName, password);
        }
        identityContext.setParameter("nacosuser", (Object)nacosUser);
        identityContext.setParameter("identity_id", (Object)nacosUser.getUserName());
        return true;
    }

    private String resolveToken(IdentityContext identityContext) {
        String bearerToken = (String)identityContext.getParameter("Authorization", (Object)"");
        if (StringUtils.isNotBlank((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring("Bearer ".length());
        }
        return (String)identityContext.getParameter("accessToken", (Object)"");
    }

    public Boolean validateAuthority(IdentityContext identityContext, Permission permission) throws AccessException {
        NacosUser user = (NacosUser)identityContext.getParameter("nacosuser");
        this.authenticationManager.authorize(permission, user);
        return true;
    }

    public String getAuthServiceName() {
        return "nacos";
    }

    public boolean isLoginEnabled() {
        return ((AuthConfigs)ApplicationUtils.getBean(AuthConfigs.class)).isAuthEnabled();
    }

    public boolean isAdminRequest() {
        boolean authEnabled = ((AuthConfigs)ApplicationUtils.getBean(AuthConfigs.class)).isAuthEnabled();
        boolean hasGlobalAdminRole = ((IAuthenticationManager)ApplicationUtils.getBean(IAuthenticationManager.class)).hasGlobalAdminRole();
        return authEnabled && !hasGlobalAdminRole;
    }

    protected void checkNacosAuthManager() {
        if (null == this.authenticationManager) {
            this.authenticationManager = (IAuthenticationManager)ApplicationUtils.getBean(DefaultAuthenticationManager.class);
        }
    }
}

