/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.consistency;

import com.alibaba.nacos.consistency.entity.GetRequest;
import com.alibaba.nacos.consistency.entity.Log;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.exception.ConsistencyException;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;

public class ProtoMessageUtil {
    public static final int REQUEST_TYPE_FIELD_TAG = 56;
    public static final int REQUEST_TYPE_READ = 1;
    public static final int REQUEST_TYPE_WRITE = 2;

    public static Message parse(byte[] bytes) {
        try {
            if (bytes[0] == 56) {
                GeneratedMessageV3 result = bytes[1] == 1 ? ReadRequest.parseFrom(bytes) : WriteRequest.parseFrom(bytes);
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            GetRequest request = GetRequest.parseFrom(bytes);
            return ProtoMessageUtil.convertToReadRequest(request);
        }
        catch (Throwable request) {
            try {
                Log log = Log.parseFrom(bytes);
                return ProtoMessageUtil.convertToWriteRequest(log);
            }
            catch (Throwable throwable) {
                throw new ConsistencyException("The current array cannot be serialized to the corresponding object");
            }
        }
    }

    public static WriteRequest convertToWriteRequest(Log log) {
        return WriteRequest.newBuilder().setKey(log.getKey()).setGroup(log.getGroup()).setData(log.getData()).setType(log.getType()).setOperation(log.getOperation()).putAllExtendInfo(log.getExtendInfoMap()).build();
    }

    public static ReadRequest convertToReadRequest(GetRequest request) {
        return ReadRequest.newBuilder().setGroup(request.getGroup()).setData(request.getData()).putAllExtendInfo(request.getExtendInfoMap()).build();
    }
}

