/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.istio.common.WatchedStatus;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractConnection<MessageT> {
    private static AtomicLong connectIdGenerator = new AtomicLong(0L);
    private String connectionId;
    protected StreamObserver<MessageT> streamObserver;
    private final Map<String, WatchedStatus> watchedResources;

    public AbstractConnection(StreamObserver<MessageT> streamObserver) {
        this.streamObserver = streamObserver;
        this.watchedResources = new HashMap<String, WatchedStatus>(16);
    }

    public void setConnectionId(String clientId) {
        long id = connectIdGenerator.getAndIncrement();
        this.connectionId = clientId + "-" + id;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void addWatchedResource(String resourceType, WatchedStatus watchedStatus) {
        this.watchedResources.put(resourceType, watchedStatus);
    }

    public WatchedStatus getWatchedStatusByType(String resourceType) {
        return this.watchedResources.get(resourceType);
    }

    public abstract void push(MessageT var1, WatchedStatus var2);
}

