/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.cluster;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.naming.cluster.ServerStatus;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alipay.sofa.jraft.RouteTable;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class ServerStatusManager {
    private final ProtocolManager protocolManager;
    private final SwitchDomain switchDomain;
    private ServerStatus serverStatus = ServerStatus.STARTING;

    public ServerStatusManager(ProtocolManager protocolManager, SwitchDomain switchDomain) {
        this.protocolManager = protocolManager;
        this.switchDomain = switchDomain;
    }

    @PostConstruct
    public void init() {
        GlobalExecutor.registerServerStatusUpdater(new ServerStatusUpdater());
    }

    private void refreshServerStatus() {
        if (StringUtils.isNotBlank((String)this.switchDomain.getOverriddenServerStatus())) {
            this.serverStatus = ServerStatus.valueOf(this.switchDomain.getOverriddenServerStatus());
            return;
        }
        this.serverStatus = this.hasLeader() ? ServerStatus.UP : ServerStatus.DOWN;
    }

    private boolean hasLeader() {
        if (this.protocolManager.getCpProtocol() == null) {
            return false;
        }
        return null != RouteTable.getInstance().selectLeader("naming_persistent_service");
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public Optional<String> getErrorMsg() {
        if (this.hasLeader()) {
            return Optional.empty();
        }
        return Optional.of("No leader for raft group naming_persistent_service, please see logs `alipay-jraft.log` or `naming-raft.log` to see details.");
    }

    public class ServerStatusUpdater
    implements Runnable {
        @Override
        public void run() {
            ServerStatusManager.this.refreshServerStatus();
        }
    }
}

