/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.misc.Loggers;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientAttributesFilter
implements Filter {
    private static final String BEAT_URI = "/beat";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String ZERO = "0";
    @Autowired
    private ClientManager clientManager;

    public static Optional<ClientAttributes> getCurrentClientAttributes() {
        Object clientAttributes = RequestContextHolder.getContext().getExtensionContext(ClientAttributes.class.getSimpleName());
        if (clientAttributes instanceof ClientAttributes) {
            return Optional.of((ClientAttributes)clientAttributes);
        }
        return Optional.empty();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String uri = request.getRequestURI();
        String method = request.getMethod();
        try {
            if (this.isRegisterInstanceUri(uri, method)) {
                ClientAttributes attributes = this.getClientAttributes();
                RequestContextHolder.getContext().addExtensionContext(ClientAttributes.class.getSimpleName(), (Object)attributes);
            } else if (this.isBeatUri(uri, method)) {
                ClientAttributes requestClientAttributes;
                String ip = WebUtils.optional((HttpServletRequest)request, (String)IP, (String)"");
                int port = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)PORT, (String)ZERO));
                String clientId = IpPortBasedClient.getClientId(ip + ":" + port, true);
                IpPortBasedClient client = (IpPortBasedClient)this.clientManager.getClient(clientId);
                if (client != null && this.canUpdateClientAttributes(client, requestClientAttributes = this.getClientAttributes())) {
                    client.setAttributes(requestClientAttributes);
                }
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.error("handler client attributes error", (Throwable)e);
        }
        try {
            filterChain.doFilter((ServletRequest)request, servletResponse);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isBeatUri(String uri, String httpMethod) {
        return ("/nacos/v1/ns/instance/beat".equals(uri) || "/nacos/v2/ns/instance/beat".equals(uri)) && "PUT".equals(httpMethod);
    }

    private boolean isRegisterInstanceUri(String uri, String httpMethod) {
        return ("/nacos/v1/ns/instance".equals(uri) || "/nacos/v2/ns/instance".equals(uri)) && "POST".equals(httpMethod);
    }

    private boolean canUpdateClientAttributes(IpPortBasedClient client, ClientAttributes requestClientAttributes) {
        if (requestClientAttributes.getClientAttribute("Client-Version") == null) {
            return false;
        }
        return client.getClientAttributes() == null || client.getClientAttributes().getClientAttribute("Client-Version") == null;
    }

    private ClientAttributes getClientAttributes() {
        String version = RequestContextHolder.getContext().getBasicContext().getUserAgent();
        String app = RequestContextHolder.getContext().getBasicContext().getApp();
        String clientIp = RequestContextHolder.getContext().getBasicContext().getAddressContext().getSourceIp();
        ClientAttributes clientAttributes = new ClientAttributes();
        if (version != null) {
            clientAttributes.addClientAttribute("Client-Version", version);
        }
        if (app != null) {
            clientAttributes.addClientAttribute("app", app);
        }
        if (clientIp != null) {
            clientAttributes.addClientAttribute("clientIp", clientIp);
        }
        return clientAttributes;
    }
}

