/*
 * Decompiled with CFR 0.152.
 */
package io.paperdb;

import android.content.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.esotericsoftware.minlog.Log;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UUIDSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import io.paperdb.KeyLocker;
import io.paperdb.PaperDbException;
import io.paperdb.PaperTable;
import io.paperdb.serializer.NoArgCollectionSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

class DbStoragePlainFile {
    private static final String BACKUP_EXTENSION = ".bak";
    private final String mDbPath;
    private final HashMap<Class, Serializer> mCustomSerializers;
    private volatile boolean mPaperDirIsCreated;
    private KeyLocker keyLocker = new KeyLocker();
    private final ThreadLocal<Kryo> mKryo = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return DbStoragePlainFile.this.createKryoInstance(false);
        }
    };

    private Kryo getKryo() {
        return this.mKryo.get();
    }

    private Kryo createKryoInstance(boolean compatibilityMode) {
        Kryo kryo = new Kryo();
        if (compatibilityMode) {
            kryo.getFieldSerializerConfig().setOptimizedGenerics(true);
        }
        kryo.register(PaperTable.class);
        kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
        kryo.setReferences(false);
        kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
        kryo.addDefaultSerializer(new ArrayList().subList(0, 0).getClass(), (Serializer)new NoArgCollectionSerializer());
        kryo.addDefaultSerializer(new LinkedList().subList(0, 0).getClass(), (Serializer)new NoArgCollectionSerializer());
        kryo.register(UUID.class, (Serializer)new UUIDSerializer());
        for (Class clazz : this.mCustomSerializers.keySet()) {
            kryo.register(clazz, this.mCustomSerializers.get(clazz));
        }
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        return kryo;
    }

    DbStoragePlainFile(Context context, String dbName, HashMap<Class, Serializer> serializers) {
        this.mCustomSerializers = serializers;
        this.mDbPath = context.getFilesDir() + File.separator + dbName;
    }

    DbStoragePlainFile(String dbFilesDir, String dbName, HashMap<Class, Serializer> serializers) {
        this.mCustomSerializers = serializers;
        this.mDbPath = dbFilesDir + File.separator + dbName;
    }

    void destroy() {
        try {
            this.keyLocker.acquireGlobal();
            if (!DbStoragePlainFile.deleteDirectory(this.mDbPath)) {
                android.util.Log.e((String)"paperdb", (String)("Couldn't delete Paper dir " + this.mDbPath));
            }
            this.mPaperDirIsCreated = false;
        }
        finally {
            this.keyLocker.releaseGlobal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E> void insert(String key, E value) {
        try {
            this.keyLocker.acquire(key);
            this.assertInit();
            PaperTable<E> paperTable = new PaperTable<E>(value);
            File originalFile = this.getOriginalFile(key);
            File backupFile = this.makeBackupFile(originalFile);
            if (originalFile.exists()) {
                if (!backupFile.exists()) {
                    if (!originalFile.renameTo(backupFile)) {
                        throw new PaperDbException("Couldn't rename file " + originalFile + " to backup file " + backupFile);
                    }
                } else {
                    originalFile.delete();
                }
            }
            this.writeTableFile(key, paperTable, originalFile, backupFile);
        }
        finally {
            this.keyLocker.release(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E> E select(String key) {
        try {
            this.keyLocker.acquire(key);
            this.assertInit();
            File originalFile = this.getOriginalFile(key);
            File backupFile = this.makeBackupFile(originalFile);
            if (backupFile.exists()) {
                originalFile.delete();
                backupFile.renameTo(originalFile);
            }
            if (!this.existsInternal(key)) {
                E e = null;
                return e;
            }
            E e = this.readTableFile(key, originalFile);
            return e;
        }
        finally {
            this.keyLocker.release(key);
        }
    }

    boolean exists(String key) {
        try {
            this.keyLocker.acquire(key);
            boolean bl = this.existsInternal(key);
            return bl;
        }
        finally {
            this.keyLocker.release(key);
        }
    }

    private boolean existsInternal(String key) {
        this.assertInit();
        File originalFile = this.getOriginalFile(key);
        return originalFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long lastModified(String key) {
        try {
            this.keyLocker.acquire(key);
            this.assertInit();
            File originalFile = this.getOriginalFile(key);
            long l = originalFile.exists() ? originalFile.lastModified() : -1L;
            return l;
        }
        finally {
            this.keyLocker.release(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getAllKeys() {
        try {
            this.keyLocker.acquireGlobal();
            this.assertInit();
            File bookFolder = new File(this.mDbPath);
            String[] names = bookFolder.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return !s.endsWith(DbStoragePlainFile.BACKUP_EXTENSION);
                }
            });
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    names[i] = names[i].replace(".pt", "");
                }
                List<String> list = Arrays.asList(names);
                return list;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            this.keyLocker.releaseGlobal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIfExists(String key) {
        try {
            this.keyLocker.acquire(key);
            this.assertInit();
            File originalFile = this.getOriginalFile(key);
            if (!originalFile.exists()) {
                return;
            }
            boolean deleted = originalFile.delete();
            if (!deleted) {
                throw new PaperDbException("Couldn't delete file " + originalFile + " for table " + key);
            }
        }
        finally {
            this.keyLocker.release(key);
        }
    }

    void setLogLevel(int level) {
        Log.set((int)level);
    }

    String getOriginalFilePath(String key) {
        return this.mDbPath + File.separator + key + ".pt";
    }

    String getRootFolderPath() {
        return this.mDbPath;
    }

    private File getOriginalFile(String key) {
        String tablePath = this.getOriginalFilePath(key);
        return new File(tablePath);
    }

    private <E> void writeTableFile(String key, PaperTable<E> paperTable, File originalFile, File backupFile) {
        try (Output kryoOutput = null;){
            FileOutputStream fileStream = new FileOutputStream(originalFile);
            kryoOutput = new Output((OutputStream)fileStream);
            this.getKryo().writeObject(kryoOutput, paperTable);
            kryoOutput.flush();
            fileStream.flush();
            DbStoragePlainFile.sync(fileStream);
            kryoOutput.close();
            kryoOutput = null;
            backupFile.delete();
        }
    }

    private <E> E readTableFile(String key, File originalFile) {
        try {
            return this.readContent(originalFile, this.getKryo());
        }
        catch (KryoException | FileNotFoundException | ClassCastException e) {
            Throwable exception = e;
            if (e instanceof KryoException) {
                try {
                    return this.readContent(originalFile, this.createKryoInstance(true));
                }
                catch (KryoException | FileNotFoundException | ClassCastException compatibleReadException) {
                    exception = compatibleReadException;
                }
            }
            String errorMessage = "Couldn't read/deserialize file " + originalFile + " for table " + key;
            throw new PaperDbException(errorMessage, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> E readContent(File originalFile, Kryo kryo) throws FileNotFoundException, KryoException {
        try (Input i = new Input((InputStream)new FileInputStream(originalFile));){
            PaperTable paperTable = (PaperTable)kryo.readObject(i, PaperTable.class);
            Object t = paperTable.mContent;
            return (E)t;
        }
    }

    private synchronized void assertInit() {
        if (!this.mPaperDirIsCreated) {
            boolean isReady;
            if (!new File(this.mDbPath).exists() && !(isReady = new File(this.mDbPath).mkdirs())) {
                throw new RuntimeException("Couldn't create Paper dir: " + this.mDbPath);
            }
            this.mPaperDirIsCreated = true;
        }
    }

    private static boolean deleteDirectory(String dirPath) {
        File[] files;
        File directory = new File(dirPath);
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (File file : files) {
                if (file.isDirectory()) {
                    DbStoragePlainFile.deleteDirectory(file.toString());
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    private File makeBackupFile(File originalFile) {
        return new File(originalFile.getPath() + BACKUP_EXTENSION);
    }

    private static void sync(FileOutputStream stream) {
        try {
            if (stream != null) {
                stream.getFD().sync();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

