/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.beans.EventHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public final class HardeningConverter
implements Converter {
    private final Set<Class<?>> dangerousTypes;
    private final List<Predicate<Class<?>>> dangerousTypeCheckers;
    private static final Set<Class<?>> defaultDangerousTypes = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(EventHandler.class, ProcessBuilder.class)));
    private static final List<Predicate<Class<?>>> defaultDangerousTypeCheckers = Collections.singletonList(Proxy::isProxyClass);
    public static final HardeningConverter DEFAULT = new HardeningConverter();

    public HardeningConverter() {
        this(defaultDangerousTypes, defaultDangerousTypeCheckers);
    }

    public HardeningConverter(Set<Class<?>> dangerousTypes, List<Predicate<Class<?>>> dangerousTypeCheckers) {
        this.dangerousTypes = dangerousTypes;
        this.dangerousTypeCheckers = dangerousTypeCheckers;
    }

    public boolean canConvert(Class type) {
        if (this.dangerousTypes.contains(type)) {
            return true;
        }
        for (Predicate<Class<?>> dangerousTypeChecker : this.dangerousTypeCheckers) {
            if (!dangerousTypeChecker.test(type)) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        throw new SecurityException("unsupported type due to security reasons");
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new SecurityException("unsupported type due to security reasons");
    }
}

