/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security;

import io.github.pixee.security.UnwantedTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@IgnoreJRERequirement
public final class ObjectInputFilters {
    private static final ObjectInputFilter basicGadgetDenylistFilter = ObjectInputFilter.Config.createFilter("!" + String.join((CharSequence)"*;!", UnwantedTypes.dangerousClassNameTokens()));

    private ObjectInputFilters() {
    }

    public static ObjectInputFilter getHardenedObjectFilter() {
        return basicGadgetDenylistFilter;
    }

    public static void enableObjectFilterIfUnprotected(ObjectInputStream ois) {
        ObjectInputFilter objectInputFilter = ois.getObjectInputFilter();
        if (objectInputFilter == null) {
            try {
                ois.setObjectInputFilter(basicGadgetDenylistFilter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ObjectInputFilter createCombinedHardenedObjectFilter(ObjectInputFilter existingFilter) {
        if (existingFilter == null) {
            return basicGadgetDenylistFilter;
        }
        return new CombinedObjectInputFilter(existingFilter);
    }

    public static ObjectInputStream createSafeObjectInputStream(InputStream ois) throws IOException {
        try {
            ValidatingObjectInputStream is = new ValidatingObjectInputStream(ois);
            for (String gadget : UnwantedTypes.dangerousClassNameTokens()) {
                is.reject("*" + gadget + "*");
            }
            return is;
        }
        catch (IOException iOException) {
            return new ObjectInputStream(ois);
        }
    }

    @IgnoreJRERequirement
    private static class CombinedObjectInputFilter
    implements ObjectInputFilter {
        private final ObjectInputFilter originalFilter;

        private CombinedObjectInputFilter(ObjectInputFilter originalFilter) {
            this.originalFilter = Objects.requireNonNull(originalFilter);
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            if (ObjectInputFilter.Status.REJECTED.equals((Object)basicGadgetDenylistFilter.checkInput(filterInfo))) {
                return ObjectInputFilter.Status.REJECTED;
            }
            return this.originalFilter.checkInput(filterInfo);
        }
    }
}

