/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security;

import io.github.pixee.security.J8ApiBridge;
import io.github.pixee.security.XMLRestrictions;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;

public final class XMLInputFactorySecurity {
    private XMLInputFactorySecurity() {
    }

    public static XMLInputFactory hardenFactory(XMLInputFactory factory) {
        return XMLInputFactorySecurity.hardenFactory(factory, J8ApiBridge.setOf(XMLRestrictions.DISALLOW_EXTERNAL_ENTITIES));
    }

    public static XMLInputFactory hardenFactory(XMLInputFactory factory, Set<XMLRestrictions> restrictions) {
        if (restrictions == null || restrictions.isEmpty()) {
            throw new IllegalArgumentException("restrictions must be non-null and non-empty");
        }
        try {
            if (restrictions.contains((Object)XMLRestrictions.DISALLOW_EXTERNAL_ENTITIES)) {
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            }
            if (restrictions.contains((Object)XMLRestrictions.DISALLOW_DOCTYPE)) {
                factory.setProperty("javax.xml.stream.supportDTD", false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return factory;
    }
}

