/*
 * Decompiled with CFR 0.152.
 */
package io.github.pixee.security;

import io.github.pixee.security.J8ApiBridge;
import io.github.pixee.security.UrlProtocol;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.Context;
import javax.naming.NamingException;

public final class JNDI {
    private JNDI() {
    }

    public static LimitedContext limitedContext(Context context) {
        return new ProtocolLimitedContext(context, J8ApiBridge.setOf(UrlProtocol.JAVA));
    }

    public static LimitedContext limitedContextByProtocol(Context context, Set<UrlProtocol> allowedProtocols) {
        return new ProtocolLimitedContext(context, allowedProtocols);
    }

    public static LimitedContext limitedContextByResourceName(Context context, Set<String> allowedResourceNames) {
        return new NameLimitedContext(context, allowedResourceNames);
    }

    private static class NameLimitedContext
    implements LimitedContext {
        private final Context context;
        private final Set<String> allowedResourceNames;

        private NameLimitedContext(Context context, Set<String> allowedResourceNames) {
            this.context = Objects.requireNonNull(context);
            this.allowedResourceNames = Objects.requireNonNull(allowedResourceNames);
        }

        @Override
        public Object lookup(String resource) throws NamingException {
            if (this.allowedResourceNames.contains(resource)) {
                return this.context.lookup(resource);
            }
            throw new SecurityException("Unexpected JNDI resource name: " + resource);
        }
    }

    private static class ProtocolLimitedContext
    implements LimitedContext {
        private final Context context;
        private final Set<UrlProtocol> allowedProtocols;

        private ProtocolLimitedContext(Context context, Set<UrlProtocol> allowedProtocols) {
            this.context = Objects.requireNonNull(context);
            this.allowedProtocols = Objects.requireNonNull(allowedProtocols);
        }

        @Override
        public Object lookup(String resource) throws NamingException {
            Set allowedProtocolPrefixes = this.allowedProtocols.stream().map(UrlProtocol::getKey).map(p -> p + ":").collect(Collectors.toSet());
            String canonicalResource = resource.toLowerCase().trim();
            if (canonicalResource.contains(":")) {
                if (allowedProtocolPrefixes.stream().anyMatch(canonicalResource::startsWith)) {
                    return this.context.lookup(resource);
                }
                throw new SecurityException("Unexpected JNDI resource protocol: " + resource);
            }
            return this.context.lookup(resource);
        }
    }

    public static interface LimitedContext {
        public Object lookup(String var1) throws NamingException;
    }
}

